<?php
/**
 * TemplatesApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\TemplatesApi;

class CreateRecipientsOptions
{
    /**
      * $resend_envelope 
      * @var string
      */
    protected $resend_envelope;

    /**
     * Gets resend_envelope
     * @return string
     */
    public function getResendEnvelope()
    {
        return $this->resend_envelope;
    }
  
    /**
     * Sets resend_envelope
     * @param string $resend_envelope 
     * @return $this
     */
    public function setResendEnvelope($resend_envelope)
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}
class GetOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class GetDocumentOptions
{
    /**
      * $encrypt 
      * @var string
      */
    protected $encrypt;

    /**
     * Gets encrypt
     * @return string
     */
    public function getEncrypt()
    {
        return $this->encrypt;
    }
  
    /**
     * Sets encrypt
     * @param string $encrypt 
     * @return $this
     */
    public function setEncrypt($encrypt)
    {
        $this->encrypt = $encrypt;
        return $this;
    }
    /**
      * $show_changes 
      * @var string
      */
    protected $show_changes;

    /**
     * Gets show_changes
     * @return string
     */
    public function getShowChanges()
    {
        return $this->show_changes;
    }
  
    /**
     * Sets show_changes
     * @param string $show_changes 
     * @return $this
     */
    public function setShowChanges($show_changes)
    {
        $this->show_changes = $show_changes;
        return $this;
    }
}
class GetDocumentPageImageOptions
{
    /**
      * $dpi 
      * @var string
      */
    protected $dpi;

    /**
     * Gets dpi
     * @return string
     */
    public function getDpi()
    {
        return $this->dpi;
    }
  
    /**
     * Sets dpi
     * @param string $dpi 
     * @return $this
     */
    public function setDpi($dpi)
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height 
      * @var string
      */
    protected $max_height;

    /**
     * Gets max_height
     * @return string
     */
    public function getMaxHeight()
    {
        return $this->max_height;
    }
  
    /**
     * Sets max_height
     * @param string $max_height 
     * @return $this
     */
    public function setMaxHeight($max_height)
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width 
      * @var string
      */
    protected $max_width;

    /**
     * Gets max_width
     * @return string
     */
    public function getMaxWidth()
    {
        return $this->max_width;
    }
  
    /**
     * Sets max_width
     * @param string $max_width 
     * @return $this
     */
    public function setMaxWidth($max_width)
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $show_changes 
      * @var string
      */
    protected $show_changes;

    /**
     * Gets show_changes
     * @return string
     */
    public function getShowChanges()
    {
        return $this->show_changes;
    }
  
    /**
     * Sets show_changes
     * @param string $show_changes 
     * @return $this
     */
    public function setShowChanges($show_changes)
    {
        $this->show_changes = $show_changes;
        return $this;
    }
}
class ListBulkRecipientsOptions
{
    /**
      * $include_tabs 
      * @var string
      */
    protected $include_tabs;

    /**
     * Gets include_tabs
     * @return string
     */
    public function getIncludeTabs()
    {
        return $this->include_tabs;
    }
  
    /**
     * Sets include_tabs
     * @param string $include_tabs 
     * @return $this
     */
    public function setIncludeTabs($include_tabs)
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
    /**
      * $start_position 
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position 
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
}
class ListRecipientsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
      * @var string
      */
    protected $include_anchor_tab_locations;

    /**
     * Gets include_anchor_tab_locations
     * @return string
     */
    public function getIncludeAnchorTabLocations()
    {
        return $this->include_anchor_tab_locations;
    }
  
    /**
     * Sets include_anchor_tab_locations
     * @param string $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
     * @return $this
     */
    public function setIncludeAnchorTabLocations($include_anchor_tab_locations)
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_extended When set to **true**, the extended properties are included in the response.
      * @var string
      */
    protected $include_extended;

    /**
     * Gets include_extended
     * @return string
     */
    public function getIncludeExtended()
    {
        return $this->include_extended;
    }
  
    /**
     * Sets include_extended
     * @param string $include_extended When set to **true**, the extended properties are included in the response.
     * @return $this
     */
    public function setIncludeExtended($include_extended)
    {
        $this->include_extended = $include_extended;
        return $this;
    }
    /**
      * $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
      * @var string
      */
    protected $include_tabs;

    /**
     * Gets include_tabs
     * @return string
     */
    public function getIncludeTabs()
    {
        return $this->include_tabs;
    }
  
    /**
     * Sets include_tabs
     * @param string $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
     * @return $this
     */
    public function setIncludeTabs($include_tabs)
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
}
class ListTabsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
      * @var string
      */
    protected $include_anchor_tab_locations;

    /**
     * Gets include_anchor_tab_locations
     * @return string
     */
    public function getIncludeAnchorTabLocations()
    {
        return $this->include_anchor_tab_locations;
    }
  
    /**
     * Sets include_anchor_tab_locations
     * @param string $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
     * @return $this
     */
    public function setIncludeAnchorTabLocations($include_anchor_tab_locations)
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_metadata 
      * @var string
      */
    protected $include_metadata;

    /**
     * Gets include_metadata
     * @return string
     */
    public function getIncludeMetadata()
    {
        return $this->include_metadata;
    }
  
    /**
     * Sets include_metadata
     * @param string $include_metadata 
     * @return $this
     */
    public function setIncludeMetadata($include_metadata)
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
}
class ListTemplatesOptions
{
    /**
      * $count Number of records to return in the cache.
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count Number of records to return in the cache.
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $folder The query value can be a folder name or folder ID. The response will only return templates in the specified folder.
      * @var string
      */
    protected $folder;

    /**
     * Gets folder
     * @return string
     */
    public function getFolder()
    {
        return $this->folder;
    }
  
    /**
     * Sets folder
     * @param string $folder The query value can be a folder name or folder ID. The response will only return templates in the specified folder.
     * @return $this
     */
    public function setFolder($folder)
    {
        $this->folder = $folder;
        return $this;
    }
    /**
      * $folder_ids A comma separated list of folder ID GUIDs.
      * @var string
      */
    protected $folder_ids;

    /**
     * Gets folder_ids
     * @return string
     */
    public function getFolderIds()
    {
        return $this->folder_ids;
    }
  
    /**
     * Sets folder_ids
     * @param string $folder_ids A comma separated list of folder ID GUIDs.
     * @return $this
     */
    public function setFolderIds($folder_ids)
    {
        $this->folder_ids = $folder_ids;
        return $this;
    }
    /**
      * $from_date Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date Start of the search date range. Only returns templates created on or after this date/time. If no value is specified, there is no limit on the earliest date created.
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $include A comma separated list of additional template attributes to include in the response. Valid values are: recipients, folders, documents, custom_fields, and notifications.
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include A comma separated list of additional template attributes to include in the response. Valid values are: recipients, folders, documents, custom_fields, and notifications.
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
    /**
      * $order Sets the direction order used to sort the list. Valid values are: -asc = ascending sort order (a to z)  -desc = descending sort order (z to a)
      * @var string
      */
    protected $order;

    /**
     * Gets order
     * @return string
     */
    public function getOrder()
    {
        return $this->order;
    }
  
    /**
     * Sets order
     * @param string $order Sets the direction order used to sort the list. Valid values are: -asc = ascending sort order (a to z)  -desc = descending sort order (z to a)
     * @return $this
     */
    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by Sets the file attribute used to sort the list. Valid values are:  -name: template name  -modified: date/time template was last modified.  -used: date/time the template was last used.
      * @var string
      */
    protected $order_by;

    /**
     * Gets order_by
     * @return string
     */
    public function getOrderBy()
    {
        return $this->order_by;
    }
  
    /**
     * Sets order_by
     * @param string $order_by Sets the file attribute used to sort the list. Valid values are:  -name: template name  -modified: date/time template was last modified.  -used: date/time the template was last used.
     * @return $this
     */
    public function setOrderBy($order_by)
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $search_text The search text used to search the names of templates.
      * @var string
      */
    protected $search_text;

    /**
     * Gets search_text
     * @return string
     */
    public function getSearchText()
    {
        return $this->search_text;
    }
  
    /**
     * Sets search_text
     * @param string $search_text The search text used to search the names of templates.
     * @return $this
     */
    public function setSearchText($search_text)
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $shared 
      * @var string
      */
    protected $shared;

    /**
     * Gets shared
     * @return string
     */
    public function getShared()
    {
        return $this->shared;
    }
  
    /**
     * Sets shared
     * @param string $shared 
     * @return $this
     */
    public function setShared($shared)
    {
        $this->shared = $shared;
        return $this;
    }
    /**
      * $shared_by_me If true, the response only includes templates shared by the user. If false, the response only returns template not shared by the user. If not specified, the response is not affected.
      * @var string
      */
    protected $shared_by_me;

    /**
     * Gets shared_by_me
     * @return string
     */
    public function getSharedByMe()
    {
        return $this->shared_by_me;
    }
  
    /**
     * Sets shared_by_me
     * @param string $shared_by_me If true, the response only includes templates shared by the user. If false, the response only returns template not shared by the user. If not specified, the response is not affected.
     * @return $this
     */
    public function setSharedByMe($shared_by_me)
    {
        $this->shared_by_me = $shared_by_me;
        return $this;
    }
    /**
      * $start_position The starting index for the first template shown in the response. This must be greater than or equal to 0 (zero).
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position The starting index for the first template shown in the response. This must be greater than or equal to 0 (zero).
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $to_date End of the search date range. Only returns templates created up to this date/time. If no value is provided, this defaults to the current date.
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date End of the search date range. Only returns templates created up to this date/time. If no value is provided, this defaults to the current date.
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
    /**
      * $used_from_date Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.
      * @var string
      */
    protected $used_from_date;

    /**
     * Gets used_from_date
     * @return string
     */
    public function getUsedFromDate()
    {
        return $this->used_from_date;
    }
  
    /**
     * Sets used_from_date
     * @param string $used_from_date Start of the search date range. Only returns templates used or edited on or after this date/time. If no value is specified, there is no limit on the earliest date used.
     * @return $this
     */
    public function setUsedFromDate($used_from_date)
    {
        $this->used_from_date = $used_from_date;
        return $this;
    }
    /**
      * $used_to_date End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.
      * @var string
      */
    protected $used_to_date;

    /**
     * Gets used_to_date
     * @return string
     */
    public function getUsedToDate()
    {
        return $this->used_to_date;
    }
  
    /**
     * Sets used_to_date
     * @param string $used_to_date End of the search date range. Only returns templates used or edited up to this date/time. If no value is provided, this defaults to the current date.
     * @return $this
     */
    public function setUsedToDate($used_to_date)
    {
        $this->used_to_date = $used_to_date;
        return $this;
    }
    /**
      * $user_filter Sets if the templates shown in the response Valid values are:  -owned_by_me: only shows templates the user owns.  -shared_with_me: only shows templates that are shared with the user.  -all: shows all templates owned or shared with the user.
      * @var string
      */
    protected $user_filter;

    /**
     * Gets user_filter
     * @return string
     */
    public function getUserFilter()
    {
        return $this->user_filter;
    }
  
    /**
     * Sets user_filter
     * @param string $user_filter Sets if the templates shown in the response Valid values are:  -owned_by_me: only shows templates the user owns.  -shared_with_me: only shows templates that are shared with the user.  -all: shows all templates owned or shared with the user.
     * @return $this
     */
    public function setUserFilter($user_filter)
    {
        $this->user_filter = $user_filter;
        return $this;
    }
}
class UpdateDocumentOptions
{
    /**
      * $apply_document_fields 
      * @var string
      */
    protected $apply_document_fields;

    /**
     * Gets apply_document_fields
     * @return string
     */
    public function getApplyDocumentFields()
    {
        return $this->apply_document_fields;
    }
  
    /**
     * Sets apply_document_fields
     * @param string $apply_document_fields 
     * @return $this
     */
    public function setApplyDocumentFields($apply_document_fields)
    {
        $this->apply_document_fields = $apply_document_fields;
        return $this;
    }
    /**
      * $is_envelope_definition 
      * @var string
      */
    protected $is_envelope_definition;

    /**
     * Gets is_envelope_definition
     * @return string
     */
    public function getIsEnvelopeDefinition()
    {
        return $this->is_envelope_definition;
    }
  
    /**
     * Sets is_envelope_definition
     * @param string $is_envelope_definition 
     * @return $this
     */
    public function setIsEnvelopeDefinition($is_envelope_definition)
    {
        $this->is_envelope_definition = $is_envelope_definition;
        return $this;
    }
}
class UpdateDocumentsOptions
{
    /**
      * $apply_document_fields 
      * @var string
      */
    protected $apply_document_fields;

    /**
     * Gets apply_document_fields
     * @return string
     */
    public function getApplyDocumentFields()
    {
        return $this->apply_document_fields;
    }
  
    /**
     * Sets apply_document_fields
     * @param string $apply_document_fields 
     * @return $this
     */
    public function setApplyDocumentFields($apply_document_fields)
    {
        $this->apply_document_fields = $apply_document_fields;
        return $this;
    }
}
class UpdateRecipientsOptions
{
    /**
      * $resend_envelope 
      * @var string
      */
    protected $resend_envelope;

    /**
     * Gets resend_envelope
     * @return string
     */
    public function getResendEnvelope()
    {
        return $this->resend_envelope;
    }
  
    /**
     * Sets resend_envelope
     * @param string $resend_envelope 
     * @return $this
     */
    public function setResendEnvelope($resend_envelope)
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * TemplatesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class TemplatesApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return TemplatesApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createCustomFields
     *
     * Creates custom document fields in an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function createCustomFields($account_id, $template_id, $template_custom_fields = null)
    {
        list($response) = $this->createCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields);
        return $response;
    }

    /**
     * Operation createCustomFieldsWithHttpInfo
     *
     * Creates custom document fields in an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_custom_fields)) {
            $_tempBody = $template_custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDocumentFields
     *
     * Creates custom document fields in an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function createDocumentFields($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        list($response) = $this->createDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation createDocumentFieldsWithHttpInfo
     *
     * Creates custom document fields in an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEditView
     *
     * Provides a URL to start an edit view of the Template UI
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createEditView($account_id, $template_id, $return_url_request = null)
    {
        list($response) = $this->createEditViewWithHttpInfo($account_id, $template_id, $return_url_request);
        return $response;
    }

    /**
     * Operation createEditViewWithHttpInfo
     *
     * Provides a URL to start an edit view of the Template UI
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEditViewWithHttpInfo($account_id, $template_id, $return_url_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEditView');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createEditView');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/views/edit";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($return_url_request)) {
            $_tempBody = $return_url_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2/accounts/{accountId}/templates/{templateId}/views/edit'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createLock
     *
     * Lock a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function createLock($account_id, $template_id, $lock_request = null)
    {
        list($response) = $this->createLockWithHttpInfo($account_id, $template_id, $lock_request);
        return $response;
    }

    /**
     * Operation createLockWithHttpInfo
     *
     * Lock a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLockWithHttpInfo($account_id, $template_id, $lock_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipients
     *
     * Adds tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function createRecipients($account_id, $template_id, $template_recipients = null, TemplatesApi\CreateRecipientsOptions $options = null)
    {
        list($response) = $this->createRecipientsWithHttpInfo($account_id, $template_id, $template_recipients, $options);
        return $response;
    }

    /**
     * Operation createRecipientsWithHttpInfo
     *
     * Adds tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientsWithHttpInfo($account_id, $template_id, $template_recipients = null, TemplatesApi\CreateRecipientsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getResendEnvelope() !== null) {
            $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTabs
     *
     * Adds tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function createTabs($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->createTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation createTabsWithHttpInfo
     *
     * Adds tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplate
     *
     * Creates an envelope from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateSummary
     */
    public function createTemplate($account_id, $envelope_template = null)
    {
        list($response) = $this->createTemplateWithHttpInfo($account_id, $envelope_template);
        return $response;
    }

    /**
     * Operation createTemplateWithHttpInfo
     *
     * Creates an envelope from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateWithHttpInfo($account_id, $envelope_template = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplate');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_template)) {
            $_tempBody = $envelope_template;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateSummary',
                '/v2/accounts/{accountId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBulkRecipients
     *
     * Deletes the bulk recipient list on a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkRecipientsUpdateResponse
     */
    public function deleteBulkRecipients($account_id, $recipient_id, $template_id)
    {
        list($response) = $this->deleteBulkRecipientsWithHttpInfo($account_id, $recipient_id, $template_id);
        return $response;
    }

    /**
     * Operation deleteBulkRecipientsWithHttpInfo
     *
     * Deletes the bulk recipient list on a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkRecipientsUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBulkRecipientsWithHttpInfo($account_id, $recipient_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBulkRecipients');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteBulkRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteBulkRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/bulk_recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkRecipientsUpdateResponse',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/bulk_recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkRecipientsUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkRecipientsUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCustomFields
     *
     * Deletes envelope custom fields in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function deleteCustomFields($account_id, $template_id, $template_custom_fields = null)
    {
        list($response) = $this->deleteCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields);
        return $response;
    }

    /**
     * Operation deleteCustomFieldsWithHttpInfo
     *
     * Deletes envelope custom fields in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_custom_fields)) {
            $_tempBody = $template_custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentFields
     *
     * Deletes custom document fields from an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function deleteDocumentFields($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        list($response) = $this->deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation deleteDocumentFieldsWithHttpInfo
     *
     * Deletes custom document fields from an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentPage
     *
     * Deletes a page from a document in an template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $page_number The page number being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteDocumentPage($account_id, $document_id, $page_number, $template_id, $page_request = null)
    {
        list($response) = $this->deleteDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request);
        return $response;
    }

    /**
     * Operation deleteDocumentPageWithHttpInfo
     *
     * Deletes a page from a document in an template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $page_number The page number being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling deleteDocumentPage');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                "{" . "pageNumber" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_number),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($page_request)) {
            $_tempBody = $page_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocuments
     *
     * Deletes documents from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentsResult
     */
    public function deleteDocuments($account_id, $template_id, $envelope_definition = null)
    {
        list($response) = $this->deleteDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition);
        return $response;
    }

    /**
     * Operation deleteDocumentsWithHttpInfo
     *
     * Deletes documents from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocuments');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteDocuments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentsResult',
                '/v2/accounts/{accountId}/templates/{templateId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteGroupShare
     *
     * Removes a member group's sharing permissions for a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
    * @param string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function deleteGroupShare($account_id, $template_id, $template_part, $group_information = null)
    {
        list($response) = $this->deleteGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information);
        return $response;
    }

    /**
     * Operation deleteGroupShareWithHttpInfo
     *
     * Removes a member group's sharing permissions for a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
    * @param string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteGroupShare');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteGroupShare');
        }
        // verify the required parameter 'template_part' is set
        if ($template_part === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_part when calling deleteGroupShare');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/{templatePart}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // path params
        if ($template_part !== null) {
            $resourcePath = str_replace(
                "{" . "templatePart" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_part),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/{templatePart}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteLock
     *
     * Deletes a template lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function deleteLock($account_id, $template_id, $lock_request = null)
    {
        list($response) = $this->deleteLockWithHttpInfo($account_id, $template_id, $lock_request);
        return $response;
    }

    /**
     * Operation deleteLockWithHttpInfo
     *
     * Deletes a template lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLockWithHttpInfo($account_id, $template_id, $lock_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipient
     *
     * Deletes the specified recipient file from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipient($account_id, $recipient_id, $template_id, $template_recipients = null)
    {
        list($response) = $this->deleteRecipientWithHttpInfo($account_id, $recipient_id, $template_id, $template_recipients);
        return $response;
    }

    /**
     * Operation deleteRecipientWithHttpInfo
     *
     * Deletes the specified recipient file from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientWithHttpInfo($account_id, $recipient_id, $template_id, $template_recipients = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipient');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteRecipient');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteRecipient');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipients
     *
     * Deletes recipients from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipients($account_id, $template_id, $template_recipients = null)
    {
        list($response) = $this->deleteRecipientsWithHttpInfo($account_id, $template_id, $template_recipients);
        return $response;
    }

    /**
     * Operation deleteRecipientsWithHttpInfo
     *
     * Deletes recipients from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientsWithHttpInfo($account_id, $template_id, $template_recipients = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTabs
     *
     * Deletes the tabs associated with a recipient in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function deleteTabs($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->deleteTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation deleteTabsWithHttpInfo
     *
     * Deletes the tabs associated with a recipient in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation get
     *
     * Gets a list of templates for a specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTemplate
     */
    public function get($account_id, $template_id, TemplatesApi\GetOptions $options = null)
    {
        list($response) = $this->getWithHttpInfo($account_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation getWithHttpInfo
     *
     * Gets a list of templates for a specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTemplate, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWithHttpInfo($account_id, $template_id, TemplatesApi\GetOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling get');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling get');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTemplate',
                '/v2/accounts/{accountId}/templates/{templateId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTemplate', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTemplate', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocument
     *
     * Gets PDF documents from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocument($account_id, $document_id, $template_id, TemplatesApi\GetDocumentOptions $options = null)
    {
        list($response) = $this->getDocumentWithHttpInfo($account_id, $document_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentWithHttpInfo
     *
     * Gets PDF documents from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentWithHttpInfo($account_id, $document_id, $template_id, TemplatesApi\GetDocumentOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocument');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/pdf']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getEncrypt() !== null) {
            $queryParams['encrypt'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncrypt());
        }
        // query params
        if ($options->getShowChanges() !== null) {
            $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocumentPageImage
     *
     * Gets a page image from a template for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $page_number The page number being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocumentPageImage($account_id, $document_id, $page_number, $template_id, TemplatesApi\GetDocumentPageImageOptions $options = null)
    {
        list($response) = $this->getDocumentPageImageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentPageImageWithHttpInfo
     *
     * Gets a page image from a template for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $page_number The page number being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentPageImageWithHttpInfo($account_id, $document_id, $page_number, $template_id, TemplatesApi\GetDocumentPageImageOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling getDocumentPageImage');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getDocumentPageImage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['image/png']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getDpi() !== null) {
            $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
        }
        // query params
        if ($options->getMaxHeight() !== null) {
            $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
        }
        // query params
        if ($options->getMaxWidth() !== null) {
            $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
        }
        // query params
        if ($options->getShowChanges() !== null) {
            $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                "{" . "pageNumber" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_number),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLock
     *
     * Gets template lock information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function getLock($account_id, $template_id)
    {
        list($response) = $this->getLockWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getLockWithHttpInfo
     *
     * Gets template lock information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLockWithHttpInfo($account_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNotificationSettings
     *
     * Gets template notification information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function getNotificationSettings($account_id, $template_id)
    {
        list($response) = $this->getNotificationSettingsWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getNotificationSettingsWithHttpInfo
     *
     * Gets template notification information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationSettingsWithHttpInfo($account_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getNotificationSettings');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/notification";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2/accounts/{accountId}/templates/{templateId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listBulkRecipients
     *
     * Gets the bulk recipient file from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkRecipientsResponse
     */
    public function listBulkRecipients($account_id, $recipient_id, $template_id, TemplatesApi\ListBulkRecipientsOptions $options = null)
    {
        list($response) = $this->listBulkRecipientsWithHttpInfo($account_id, $recipient_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation listBulkRecipientsWithHttpInfo
     *
     * Gets the bulk recipient file from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkRecipientsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBulkRecipientsWithHttpInfo($account_id, $recipient_id, $template_id, TemplatesApi\ListBulkRecipientsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listBulkRecipients');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling listBulkRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listBulkRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/bulk_recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeTabs() !== null) {
            $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkRecipientsResponse',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/bulk_recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkRecipientsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkRecipientsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomFields
     *
     * Gets the custom document fields from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function listCustomFields($account_id, $template_id)
    {
        list($response) = $this->listCustomFieldsWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation listCustomFieldsWithHttpInfo
     *
     * Gets the custom document fields from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomFieldsWithHttpInfo($account_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocumentFields
     *
     * Gets the custom document fields for a an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function listDocumentFields($account_id, $document_id, $template_id)
    {
        list($response) = $this->listDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id);
        return $response;
    }

    /**
     * Operation listDocumentFieldsWithHttpInfo
     *
     * Gets the custom document fields for a an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling listDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocuments
     *
     * Gets a list of documents associated with a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentsResult
     */
    public function listDocuments($account_id, $template_id)
    {
        list($response) = $this->listDocumentsWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation listDocumentsWithHttpInfo
     *
     * Gets a list of documents associated with a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentsWithHttpInfo($account_id, $template_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocuments');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listDocuments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentsResult',
                '/v2/accounts/{accountId}/templates/{templateId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listRecipients
     *
     * Gets recipient information from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function listRecipients($account_id, $template_id, TemplatesApi\ListRecipientsOptions $options = null)
    {
        list($response) = $this->listRecipientsWithHttpInfo($account_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation listRecipientsWithHttpInfo
     *
     * Gets recipient information from a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRecipientsWithHttpInfo($account_id, $template_id, TemplatesApi\ListRecipientsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeAnchorTabLocations() !== null) {
            $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
        }
        // query params
        if ($options->getIncludeExtended() !== null) {
            $queryParams['include_extended'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeExtended());
        }
        // query params
        if ($options->getIncludeTabs() !== null) {
            $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTabs
     *
     * Gets the tabs information for a signer or sign-in-person recipient in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function listTabs($account_id, $recipient_id, $template_id, TemplatesApi\ListTabsOptions $options = null)
    {
        list($response) = $this->listTabsWithHttpInfo($account_id, $recipient_id, $template_id, $options);
        return $response;
    }

    /**
     * Operation listTabsWithHttpInfo
     *
     * Gets the tabs information for a signer or sign-in-person recipient in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTabsWithHttpInfo($account_id, $recipient_id, $template_id, TemplatesApi\ListTabsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling listTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling listTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeAnchorTabLocations() !== null) {
            $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
        }
        // query params
        if ($options->getIncludeMetadata() !== null) {
            $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTemplates
     *
     * Gets the definition of a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTemplateResults
     */
    public function listTemplates($account_id, TemplatesApi\ListTemplatesOptions $options = null)
    {
        list($response) = $this->listTemplatesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listTemplatesWithHttpInfo
     *
     * Gets the definition of a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTemplateResults, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTemplatesWithHttpInfo($account_id, TemplatesApi\ListTemplatesOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTemplates');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getFolder() !== null) {
            $queryParams['folder'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolder());
        }
        // query params
        if ($options->getFolderIds() !== null) {
            $queryParams['folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderIds());
        }
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        // query params
        if ($options->getOrder() !== null) {
            $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
        }
        // query params
        if ($options->getOrderBy() !== null) {
            $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
        }
        // query params
        if ($options->getSearchText() !== null) {
            $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
        }
        // query params
        if ($options->getShared() !== null) {
            $queryParams['shared'] = $this->apiClient->getSerializer()->toQueryValue($options->getShared());
        }
        // query params
        if ($options->getSharedByMe() !== null) {
            $queryParams['shared_by_me'] = $this->apiClient->getSerializer()->toQueryValue($options->getSharedByMe());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        // query params
        if ($options->getUsedFromDate() !== null) {
            $queryParams['used_from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getUsedFromDate());
        }
        // query params
        if ($options->getUsedToDate() !== null) {
            $queryParams['used_to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getUsedToDate());
        }
        // query params
        if ($options->getUserFilter() !== null) {
            $queryParams['user_filter'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserFilter());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTemplateResults',
                '/v2/accounts/{accountId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTemplateResults', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTemplateResults', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation rotateDocumentPage
     *
     * Rotates page image from a template for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $page_number The page number being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function rotateDocumentPage($account_id, $document_id, $page_number, $template_id, $page_request = null)
    {
        list($response) = $this->rotateDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request);
        return $response;
    }

    /**
     * Operation rotateDocumentPageWithHttpInfo
     *
     * Rotates page image from a template for display.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $page_number The page number being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function rotateDocumentPageWithHttpInfo($account_id, $document_id, $page_number, $template_id, $page_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling rotateDocumentPage');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling rotateDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                "{" . "pageNumber" . "}",
                $this->apiClient->getSerializer()->toPathValue($page_number),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($page_request)) {
            $_tempBody = $page_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation update
     *
     * Updates an existing template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateUpdateSummary
     */
    public function update($account_id, $template_id, $envelope_template = null)
    {
        list($response) = $this->updateWithHttpInfo($account_id, $template_id, $envelope_template);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Updates an existing template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeTemplate $envelope_template  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($account_id, $template_id, $envelope_template = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling update');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling update');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_template)) {
            $_tempBody = $envelope_template;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateUpdateSummary',
                '/v2/accounts/{accountId}/templates/{templateId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBulkRecipients
     *
     * Adds or replaces the bulk recipients list in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\BulkRecipientsRequest $bulk_recipients_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BulkRecipientsSummaryResponse
     */
    public function updateBulkRecipients($account_id, $recipient_id, $template_id, $bulk_recipients_request = null)
    {
        list($response) = $this->updateBulkRecipientsWithHttpInfo($account_id, $recipient_id, $template_id, $bulk_recipients_request);
        return $response;
    }

    /**
     * Operation updateBulkRecipientsWithHttpInfo
     *
     * Adds or replaces the bulk recipients list in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\BulkRecipientsRequest $bulk_recipients_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BulkRecipientsSummaryResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBulkRecipientsWithHttpInfo($account_id, $recipient_id, $template_id, $bulk_recipients_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBulkRecipients');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateBulkRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateBulkRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/bulk_recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($bulk_recipients_request)) {
            $_tempBody = $bulk_recipients_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BulkRecipientsSummaryResponse',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/bulk_recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BulkRecipientsSummaryResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BulkRecipientsSummaryResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateCustomFields
     *
     * Updates envelope custom fields in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function updateCustomFields($account_id, $template_id, $template_custom_fields = null)
    {
        list($response) = $this->updateCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields);
        return $response;
    }

    /**
     * Operation updateCustomFieldsWithHttpInfo
     *
     * Updates envelope custom fields in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateCustomFields $template_custom_fields  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldsWithHttpInfo($account_id, $template_id, $template_custom_fields = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateCustomFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_custom_fields)) {
            $_tempBody = $template_custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/templates/{templateId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocument
     *
     * Adds a document to a template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocument
     */
    public function updateDocument($account_id, $document_id, $template_id, $envelope_definition = null, TemplatesApi\UpdateDocumentOptions $options = null)
    {
        list($response) = $this->updateDocumentWithHttpInfo($account_id, $document_id, $template_id, $envelope_definition, $options);
        return $response;
    }

    /**
     * Operation updateDocumentWithHttpInfo
     *
     * Adds a document to a template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocument, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentWithHttpInfo($account_id, $document_id, $template_id, $envelope_definition = null, TemplatesApi\UpdateDocumentOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocument');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateDocument');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getApplyDocumentFields() !== null) {
            $queryParams['apply_document_fields'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyDocumentFields());
        }
        // query params
        if ($options->getIsEnvelopeDefinition() !== null) {
            $queryParams['is_envelope_definition'] = $this->apiClient->getSerializer()->toQueryValue($options->getIsEnvelopeDefinition());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocument',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocument', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocumentFields
     *
     * Updates existing custom document fields in an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function updateDocumentFields($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        list($response) = $this->updateDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation updateDocumentFieldsWithHttpInfo
     *
     * Updates existing custom document fields in an existing template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $document_id The ID of the document being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentFieldsWithHttpInfo($account_id, $document_id, $template_id, $document_fields_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocumentFields');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = str_replace(
                "{" . "documentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($document_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocuments
     *
     * Adds documents to a template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentsResult
     */
    public function updateDocuments($account_id, $template_id, $envelope_definition = null, TemplatesApi\UpdateDocumentsOptions $options = null)
    {
        list($response) = $this->updateDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition, $options);
        return $response;
    }

    /**
     * Operation updateDocumentsWithHttpInfo
     *
     * Adds documents to a template document.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentsWithHttpInfo($account_id, $template_id, $envelope_definition = null, TemplatesApi\UpdateDocumentsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocuments');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateDocuments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/documents";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getApplyDocumentFields() !== null) {
            $queryParams['apply_document_fields'] = $this->apiClient->getSerializer()->toQueryValue($options->getApplyDocumentFields());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentsResult',
                '/v2/accounts/{accountId}/templates/{templateId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateGroupShare
     *
     * Shares a template with a group
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
    * @param string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function updateGroupShare($account_id, $template_id, $template_part, $group_information = null)
    {
        list($response) = $this->updateGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information);
        return $response;
    }

    /**
     * Operation updateGroupShareWithHttpInfo
     *
     * Shares a template with a group
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
    * @param string $template_part Currently, the only defined part is **groups**.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupShareWithHttpInfo($account_id, $template_id, $template_part, $group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateGroupShare');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateGroupShare');
        }
        // verify the required parameter 'template_part' is set
        if ($template_part === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_part when calling updateGroupShare');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/{templatePart}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // path params
        if ($template_part !== null) {
            $resourcePath = str_replace(
                "{" . "templatePart" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_part),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/{templatePart}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateLock
     *
     * Updates a template lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function updateLock($account_id, $template_id, $lock_request = null)
    {
        list($response) = $this->updateLockWithHttpInfo($account_id, $template_id, $lock_request);
        return $response;
    }

    /**
     * Operation updateLockWithHttpInfo
     *
     * Updates a template lock.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLockWithHttpInfo($account_id, $template_id, $lock_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateLock');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateLock');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/lock";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2/accounts/{accountId}/templates/{templateId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNotificationSettings
     *
     * Updates the notification  structure for an existing template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateNotificationRequest $template_notification_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function updateNotificationSettings($account_id, $template_id, $template_notification_request = null)
    {
        list($response) = $this->updateNotificationSettingsWithHttpInfo($account_id, $template_id, $template_notification_request);
        return $response;
    }

    /**
     * Operation updateNotificationSettingsWithHttpInfo
     *
     * Updates the notification  structure for an existing template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateNotificationRequest $template_notification_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNotificationSettingsWithHttpInfo($account_id, $template_id, $template_notification_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateNotificationSettings');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/notification";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_notification_request)) {
            $_tempBody = $template_notification_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2/accounts/{accountId}/templates/{templateId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipients
     *
     * Updates recipients in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\RecipientsUpdateSummary
     */
    public function updateRecipients($account_id, $template_id, $template_recipients = null, TemplatesApi\UpdateRecipientsOptions $options = null)
    {
        list($response) = $this->updateRecipientsWithHttpInfo($account_id, $template_id, $template_recipients, $options);
        return $response;
    }

    /**
     * Operation updateRecipientsWithHttpInfo
     *
     * Updates recipients in a template.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateRecipients $template_recipients  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\RecipientsUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientsWithHttpInfo($account_id, $template_id, $template_recipients = null, TemplatesApi\UpdateRecipientsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipients');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateRecipients');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getResendEnvelope() !== null) {
            $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_recipients)) {
            $_tempBody = $template_recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\RecipientsUpdateSummary',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\RecipientsUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\RecipientsUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTabs
     *
     * Updates the tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function updateTabs($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        list($response) = $this->updateTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs);
        return $response;
    }

    /**
     * Operation updateTabsWithHttpInfo
     *
     * Updates the tabs for a recipient.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_id The ID of the recipient being accessed.
    * @param string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateTabs $template_tabs  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTabsWithHttpInfo($account_id, $recipient_id, $template_id, $template_tabs = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateTabs');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTabs');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = str_replace(
                "{" . "recipientId" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_id),
                $resourcePath
            );
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = str_replace(
                "{" . "templateId" . "}",
                $this->apiClient->getSerializer()->toPathValue($template_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($template_tabs)) {
            $_tempBody = $template_tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
