<?php
/**
 * AccountRoleSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * AccountRoleSettings Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AccountRoleSettings implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'accountRoleSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'allow_account_management' => 'string',
        'allow_account_management_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_access' => 'string',
        'allow_api_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_access_to_account' => 'string',
        'allow_api_access_to_account_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_sending_on_behalf_of_others' => 'string',
        'allow_api_sending_on_behalf_of_others_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_api_sequential_signing' => 'string',
        'allow_api_sequential_signing_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_bulk_sending' => 'string',
        'allow_bulk_sending_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_docu_sign_desktop_client' => 'string',
        'allow_docu_sign_desktop_client_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_address_book_access' => 'string',
        'allowed_address_book_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_template_access' => 'string',
        'allowed_template_access_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'string',
        'allowed_to_be_envelope_transfer_recipient_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_envelope_sending' => 'string',
        'allow_envelope_sending_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_senders_to_set_recipient_email_language' => 'string',
        'allow_senders_to_set_recipient_email_language_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_signer_attachments' => 'string',
        'allow_signer_attachments_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_supplemental_documents' => 'string',
        'allow_supplemental_documents_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_tagging_in_send_and_correct' => 'string',
        'allow_tagging_in_send_and_correct_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_vaulting' => 'string',
        'allow_vaulting_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'allow_wet_signing_override' => 'string',
        'allow_wet_signing_override_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'can_create_workspaces' => 'string',
        'can_create_workspaces_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_document_upload' => 'string',
        'disable_document_upload_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'disable_other_actions' => 'string',
        'disable_other_actions_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_api_request_logging' => 'string',
        'enable_api_request_logging_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_recipient_viewing_notifications' => 'string',
        'enable_recipient_viewing_notifications_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_sequential_signing_interface' => 'string',
        'enable_sequential_signing_interface_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'enable_transaction_point_integration' => 'string',
        'enable_transaction_point_integration_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'power_form_role' => 'string',
        'power_form_role_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'string',
        'receive_completed_self_signed_documents_as_email_links_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_accept' => 'string',
        'supplemental_documents_must_accept_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_read' => 'string',
        'supplemental_documents_must_read_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'supplemental_documents_must_view' => 'string',
        'supplemental_documents_must_view_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_docu_sign_experience_interface' => 'string',
        'use_new_docu_sign_experience_interface_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'use_new_sending_interface' => 'string',
        'use_new_sending_interface_metadata' => '\DocuSign\eSign\Model\SettingsMetadata',
        'vaulting_mode' => 'string',
        'vaulting_mode_metadata' => '\DocuSign\eSign\Model\SettingsMetadata'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'allow_account_management' => 'allowAccountManagement',
        'allow_account_management_metadata' => 'allowAccountManagementMetadata',
        'allow_api_access' => 'allowApiAccess',
        'allow_api_access_metadata' => 'allowApiAccessMetadata',
        'allow_api_access_to_account' => 'allowApiAccessToAccount',
        'allow_api_access_to_account_metadata' => 'allowApiAccessToAccountMetadata',
        'allow_api_sending_on_behalf_of_others' => 'allowApiSendingOnBehalfOfOthers',
        'allow_api_sending_on_behalf_of_others_metadata' => 'allowApiSendingOnBehalfOfOthersMetadata',
        'allow_api_sequential_signing' => 'allowApiSequentialSigning',
        'allow_api_sequential_signing_metadata' => 'allowApiSequentialSigningMetadata',
        'allow_bulk_sending' => 'allowBulkSending',
        'allow_bulk_sending_metadata' => 'allowBulkSendingMetadata',
        'allow_docu_sign_desktop_client' => 'allowDocuSignDesktopClient',
        'allow_docu_sign_desktop_client_metadata' => 'allowDocuSignDesktopClientMetadata',
        'allowed_address_book_access' => 'allowedAddressBookAccess',
        'allowed_address_book_access_metadata' => 'allowedAddressBookAccessMetadata',
        'allowed_template_access' => 'allowedTemplateAccess',
        'allowed_template_access_metadata' => 'allowedTemplateAccessMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'allowedToBeEnvelopeTransferRecipient',
        'allowed_to_be_envelope_transfer_recipient_metadata' => 'allowedToBeEnvelopeTransferRecipientMetadata',
        'allow_envelope_sending' => 'allowEnvelopeSending',
        'allow_envelope_sending_metadata' => 'allowEnvelopeSendingMetadata',
        'allow_senders_to_set_recipient_email_language' => 'allowSendersToSetRecipientEmailLanguage',
        'allow_senders_to_set_recipient_email_language_metadata' => 'allowSendersToSetRecipientEmailLanguageMetadata',
        'allow_signer_attachments' => 'allowSignerAttachments',
        'allow_signer_attachments_metadata' => 'allowSignerAttachmentsMetadata',
        'allow_supplemental_documents' => 'allowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'allowSupplementalDocumentsMetadata',
        'allow_tagging_in_send_and_correct' => 'allowTaggingInSendAndCorrect',
        'allow_tagging_in_send_and_correct_metadata' => 'allowTaggingInSendAndCorrectMetadata',
        'allow_vaulting' => 'allowVaulting',
        'allow_vaulting_metadata' => 'allowVaultingMetadata',
        'allow_wet_signing_override' => 'allowWetSigningOverride',
        'allow_wet_signing_override_metadata' => 'allowWetSigningOverrideMetadata',
        'can_create_workspaces' => 'canCreateWorkspaces',
        'can_create_workspaces_metadata' => 'canCreateWorkspacesMetadata',
        'disable_document_upload' => 'disableDocumentUpload',
        'disable_document_upload_metadata' => 'disableDocumentUploadMetadata',
        'disable_other_actions' => 'disableOtherActions',
        'disable_other_actions_metadata' => 'disableOtherActionsMetadata',
        'enable_api_request_logging' => 'enableApiRequestLogging',
        'enable_api_request_logging_metadata' => 'enableApiRequestLoggingMetadata',
        'enable_recipient_viewing_notifications' => 'enableRecipientViewingNotifications',
        'enable_recipient_viewing_notifications_metadata' => 'enableRecipientViewingNotificationsMetadata',
        'enable_sequential_signing_interface' => 'enableSequentialSigningInterface',
        'enable_sequential_signing_interface_metadata' => 'enableSequentialSigningInterfaceMetadata',
        'enable_transaction_point_integration' => 'enableTransactionPointIntegration',
        'enable_transaction_point_integration_metadata' => 'enableTransactionPointIntegrationMetadata',
        'power_form_role' => 'powerFormRole',
        'power_form_role_metadata' => 'powerFormRoleMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'receiveCompletedSelfSignedDocumentsAsEmailLinks',
        'receive_completed_self_signed_documents_as_email_links_metadata' => 'receiveCompletedSelfSignedDocumentsAsEmailLinksMetadata',
        'supplemental_documents_must_accept' => 'supplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'supplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'supplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'supplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'supplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'supplementalDocumentsMustViewMetadata',
        'use_new_docu_sign_experience_interface' => 'useNewDocuSignExperienceInterface',
        'use_new_docu_sign_experience_interface_metadata' => 'useNewDocuSignExperienceInterfaceMetadata',
        'use_new_sending_interface' => 'useNewSendingInterface',
        'use_new_sending_interface_metadata' => 'useNewSendingInterfaceMetadata',
        'vaulting_mode' => 'vaultingMode',
        'vaulting_mode_metadata' => 'vaultingModeMetadata'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'allow_account_management' => 'setAllowAccountManagement',
        'allow_account_management_metadata' => 'setAllowAccountManagementMetadata',
        'allow_api_access' => 'setAllowApiAccess',
        'allow_api_access_metadata' => 'setAllowApiAccessMetadata',
        'allow_api_access_to_account' => 'setAllowApiAccessToAccount',
        'allow_api_access_to_account_metadata' => 'setAllowApiAccessToAccountMetadata',
        'allow_api_sending_on_behalf_of_others' => 'setAllowApiSendingOnBehalfOfOthers',
        'allow_api_sending_on_behalf_of_others_metadata' => 'setAllowApiSendingOnBehalfOfOthersMetadata',
        'allow_api_sequential_signing' => 'setAllowApiSequentialSigning',
        'allow_api_sequential_signing_metadata' => 'setAllowApiSequentialSigningMetadata',
        'allow_bulk_sending' => 'setAllowBulkSending',
        'allow_bulk_sending_metadata' => 'setAllowBulkSendingMetadata',
        'allow_docu_sign_desktop_client' => 'setAllowDocuSignDesktopClient',
        'allow_docu_sign_desktop_client_metadata' => 'setAllowDocuSignDesktopClientMetadata',
        'allowed_address_book_access' => 'setAllowedAddressBookAccess',
        'allowed_address_book_access_metadata' => 'setAllowedAddressBookAccessMetadata',
        'allowed_template_access' => 'setAllowedTemplateAccess',
        'allowed_template_access_metadata' => 'setAllowedTemplateAccessMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'setAllowedToBeEnvelopeTransferRecipient',
        'allowed_to_be_envelope_transfer_recipient_metadata' => 'setAllowedToBeEnvelopeTransferRecipientMetadata',
        'allow_envelope_sending' => 'setAllowEnvelopeSending',
        'allow_envelope_sending_metadata' => 'setAllowEnvelopeSendingMetadata',
        'allow_senders_to_set_recipient_email_language' => 'setAllowSendersToSetRecipientEmailLanguage',
        'allow_senders_to_set_recipient_email_language_metadata' => 'setAllowSendersToSetRecipientEmailLanguageMetadata',
        'allow_signer_attachments' => 'setAllowSignerAttachments',
        'allow_signer_attachments_metadata' => 'setAllowSignerAttachmentsMetadata',
        'allow_supplemental_documents' => 'setAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'setAllowSupplementalDocumentsMetadata',
        'allow_tagging_in_send_and_correct' => 'setAllowTaggingInSendAndCorrect',
        'allow_tagging_in_send_and_correct_metadata' => 'setAllowTaggingInSendAndCorrectMetadata',
        'allow_vaulting' => 'setAllowVaulting',
        'allow_vaulting_metadata' => 'setAllowVaultingMetadata',
        'allow_wet_signing_override' => 'setAllowWetSigningOverride',
        'allow_wet_signing_override_metadata' => 'setAllowWetSigningOverrideMetadata',
        'can_create_workspaces' => 'setCanCreateWorkspaces',
        'can_create_workspaces_metadata' => 'setCanCreateWorkspacesMetadata',
        'disable_document_upload' => 'setDisableDocumentUpload',
        'disable_document_upload_metadata' => 'setDisableDocumentUploadMetadata',
        'disable_other_actions' => 'setDisableOtherActions',
        'disable_other_actions_metadata' => 'setDisableOtherActionsMetadata',
        'enable_api_request_logging' => 'setEnableApiRequestLogging',
        'enable_api_request_logging_metadata' => 'setEnableApiRequestLoggingMetadata',
        'enable_recipient_viewing_notifications' => 'setEnableRecipientViewingNotifications',
        'enable_recipient_viewing_notifications_metadata' => 'setEnableRecipientViewingNotificationsMetadata',
        'enable_sequential_signing_interface' => 'setEnableSequentialSigningInterface',
        'enable_sequential_signing_interface_metadata' => 'setEnableSequentialSigningInterfaceMetadata',
        'enable_transaction_point_integration' => 'setEnableTransactionPointIntegration',
        'enable_transaction_point_integration_metadata' => 'setEnableTransactionPointIntegrationMetadata',
        'power_form_role' => 'setPowerFormRole',
        'power_form_role_metadata' => 'setPowerFormRoleMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'setReceiveCompletedSelfSignedDocumentsAsEmailLinks',
        'receive_completed_self_signed_documents_as_email_links_metadata' => 'setReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata',
        'supplemental_documents_must_accept' => 'setSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'setSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'setSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'setSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'setSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'setSupplementalDocumentsMustViewMetadata',
        'use_new_docu_sign_experience_interface' => 'setUseNewDocuSignExperienceInterface',
        'use_new_docu_sign_experience_interface_metadata' => 'setUseNewDocuSignExperienceInterfaceMetadata',
        'use_new_sending_interface' => 'setUseNewSendingInterface',
        'use_new_sending_interface_metadata' => 'setUseNewSendingInterfaceMetadata',
        'vaulting_mode' => 'setVaultingMode',
        'vaulting_mode_metadata' => 'setVaultingModeMetadata'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'allow_account_management' => 'getAllowAccountManagement',
        'allow_account_management_metadata' => 'getAllowAccountManagementMetadata',
        'allow_api_access' => 'getAllowApiAccess',
        'allow_api_access_metadata' => 'getAllowApiAccessMetadata',
        'allow_api_access_to_account' => 'getAllowApiAccessToAccount',
        'allow_api_access_to_account_metadata' => 'getAllowApiAccessToAccountMetadata',
        'allow_api_sending_on_behalf_of_others' => 'getAllowApiSendingOnBehalfOfOthers',
        'allow_api_sending_on_behalf_of_others_metadata' => 'getAllowApiSendingOnBehalfOfOthersMetadata',
        'allow_api_sequential_signing' => 'getAllowApiSequentialSigning',
        'allow_api_sequential_signing_metadata' => 'getAllowApiSequentialSigningMetadata',
        'allow_bulk_sending' => 'getAllowBulkSending',
        'allow_bulk_sending_metadata' => 'getAllowBulkSendingMetadata',
        'allow_docu_sign_desktop_client' => 'getAllowDocuSignDesktopClient',
        'allow_docu_sign_desktop_client_metadata' => 'getAllowDocuSignDesktopClientMetadata',
        'allowed_address_book_access' => 'getAllowedAddressBookAccess',
        'allowed_address_book_access_metadata' => 'getAllowedAddressBookAccessMetadata',
        'allowed_template_access' => 'getAllowedTemplateAccess',
        'allowed_template_access_metadata' => 'getAllowedTemplateAccessMetadata',
        'allowed_to_be_envelope_transfer_recipient' => 'getAllowedToBeEnvelopeTransferRecipient',
        'allowed_to_be_envelope_transfer_recipient_metadata' => 'getAllowedToBeEnvelopeTransferRecipientMetadata',
        'allow_envelope_sending' => 'getAllowEnvelopeSending',
        'allow_envelope_sending_metadata' => 'getAllowEnvelopeSendingMetadata',
        'allow_senders_to_set_recipient_email_language' => 'getAllowSendersToSetRecipientEmailLanguage',
        'allow_senders_to_set_recipient_email_language_metadata' => 'getAllowSendersToSetRecipientEmailLanguageMetadata',
        'allow_signer_attachments' => 'getAllowSignerAttachments',
        'allow_signer_attachments_metadata' => 'getAllowSignerAttachmentsMetadata',
        'allow_supplemental_documents' => 'getAllowSupplementalDocuments',
        'allow_supplemental_documents_metadata' => 'getAllowSupplementalDocumentsMetadata',
        'allow_tagging_in_send_and_correct' => 'getAllowTaggingInSendAndCorrect',
        'allow_tagging_in_send_and_correct_metadata' => 'getAllowTaggingInSendAndCorrectMetadata',
        'allow_vaulting' => 'getAllowVaulting',
        'allow_vaulting_metadata' => 'getAllowVaultingMetadata',
        'allow_wet_signing_override' => 'getAllowWetSigningOverride',
        'allow_wet_signing_override_metadata' => 'getAllowWetSigningOverrideMetadata',
        'can_create_workspaces' => 'getCanCreateWorkspaces',
        'can_create_workspaces_metadata' => 'getCanCreateWorkspacesMetadata',
        'disable_document_upload' => 'getDisableDocumentUpload',
        'disable_document_upload_metadata' => 'getDisableDocumentUploadMetadata',
        'disable_other_actions' => 'getDisableOtherActions',
        'disable_other_actions_metadata' => 'getDisableOtherActionsMetadata',
        'enable_api_request_logging' => 'getEnableApiRequestLogging',
        'enable_api_request_logging_metadata' => 'getEnableApiRequestLoggingMetadata',
        'enable_recipient_viewing_notifications' => 'getEnableRecipientViewingNotifications',
        'enable_recipient_viewing_notifications_metadata' => 'getEnableRecipientViewingNotificationsMetadata',
        'enable_sequential_signing_interface' => 'getEnableSequentialSigningInterface',
        'enable_sequential_signing_interface_metadata' => 'getEnableSequentialSigningInterfaceMetadata',
        'enable_transaction_point_integration' => 'getEnableTransactionPointIntegration',
        'enable_transaction_point_integration_metadata' => 'getEnableTransactionPointIntegrationMetadata',
        'power_form_role' => 'getPowerFormRole',
        'power_form_role_metadata' => 'getPowerFormRoleMetadata',
        'receive_completed_self_signed_documents_as_email_links' => 'getReceiveCompletedSelfSignedDocumentsAsEmailLinks',
        'receive_completed_self_signed_documents_as_email_links_metadata' => 'getReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata',
        'supplemental_documents_must_accept' => 'getSupplementalDocumentsMustAccept',
        'supplemental_documents_must_accept_metadata' => 'getSupplementalDocumentsMustAcceptMetadata',
        'supplemental_documents_must_read' => 'getSupplementalDocumentsMustRead',
        'supplemental_documents_must_read_metadata' => 'getSupplementalDocumentsMustReadMetadata',
        'supplemental_documents_must_view' => 'getSupplementalDocumentsMustView',
        'supplemental_documents_must_view_metadata' => 'getSupplementalDocumentsMustViewMetadata',
        'use_new_docu_sign_experience_interface' => 'getUseNewDocuSignExperienceInterface',
        'use_new_docu_sign_experience_interface_metadata' => 'getUseNewDocuSignExperienceInterfaceMetadata',
        'use_new_sending_interface' => 'getUseNewSendingInterface',
        'use_new_sending_interface_metadata' => 'getUseNewSendingInterfaceMetadata',
        'vaulting_mode' => 'getVaultingMode',
        'vaulting_mode_metadata' => 'getVaultingModeMetadata'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['allow_account_management'] = isset($data['allow_account_management']) ? $data['allow_account_management'] : null;
        $this->container['allow_account_management_metadata'] = isset($data['allow_account_management_metadata']) ? $data['allow_account_management_metadata'] : null;
        $this->container['allow_api_access'] = isset($data['allow_api_access']) ? $data['allow_api_access'] : null;
        $this->container['allow_api_access_metadata'] = isset($data['allow_api_access_metadata']) ? $data['allow_api_access_metadata'] : null;
        $this->container['allow_api_access_to_account'] = isset($data['allow_api_access_to_account']) ? $data['allow_api_access_to_account'] : null;
        $this->container['allow_api_access_to_account_metadata'] = isset($data['allow_api_access_to_account_metadata']) ? $data['allow_api_access_to_account_metadata'] : null;
        $this->container['allow_api_sending_on_behalf_of_others'] = isset($data['allow_api_sending_on_behalf_of_others']) ? $data['allow_api_sending_on_behalf_of_others'] : null;
        $this->container['allow_api_sending_on_behalf_of_others_metadata'] = isset($data['allow_api_sending_on_behalf_of_others_metadata']) ? $data['allow_api_sending_on_behalf_of_others_metadata'] : null;
        $this->container['allow_api_sequential_signing'] = isset($data['allow_api_sequential_signing']) ? $data['allow_api_sequential_signing'] : null;
        $this->container['allow_api_sequential_signing_metadata'] = isset($data['allow_api_sequential_signing_metadata']) ? $data['allow_api_sequential_signing_metadata'] : null;
        $this->container['allow_bulk_sending'] = isset($data['allow_bulk_sending']) ? $data['allow_bulk_sending'] : null;
        $this->container['allow_bulk_sending_metadata'] = isset($data['allow_bulk_sending_metadata']) ? $data['allow_bulk_sending_metadata'] : null;
        $this->container['allow_docu_sign_desktop_client'] = isset($data['allow_docu_sign_desktop_client']) ? $data['allow_docu_sign_desktop_client'] : null;
        $this->container['allow_docu_sign_desktop_client_metadata'] = isset($data['allow_docu_sign_desktop_client_metadata']) ? $data['allow_docu_sign_desktop_client_metadata'] : null;
        $this->container['allowed_address_book_access'] = isset($data['allowed_address_book_access']) ? $data['allowed_address_book_access'] : null;
        $this->container['allowed_address_book_access_metadata'] = isset($data['allowed_address_book_access_metadata']) ? $data['allowed_address_book_access_metadata'] : null;
        $this->container['allowed_template_access'] = isset($data['allowed_template_access']) ? $data['allowed_template_access'] : null;
        $this->container['allowed_template_access_metadata'] = isset($data['allowed_template_access_metadata']) ? $data['allowed_template_access_metadata'] : null;
        $this->container['allowed_to_be_envelope_transfer_recipient'] = isset($data['allowed_to_be_envelope_transfer_recipient']) ? $data['allowed_to_be_envelope_transfer_recipient'] : null;
        $this->container['allowed_to_be_envelope_transfer_recipient_metadata'] = isset($data['allowed_to_be_envelope_transfer_recipient_metadata']) ? $data['allowed_to_be_envelope_transfer_recipient_metadata'] : null;
        $this->container['allow_envelope_sending'] = isset($data['allow_envelope_sending']) ? $data['allow_envelope_sending'] : null;
        $this->container['allow_envelope_sending_metadata'] = isset($data['allow_envelope_sending_metadata']) ? $data['allow_envelope_sending_metadata'] : null;
        $this->container['allow_senders_to_set_recipient_email_language'] = isset($data['allow_senders_to_set_recipient_email_language']) ? $data['allow_senders_to_set_recipient_email_language'] : null;
        $this->container['allow_senders_to_set_recipient_email_language_metadata'] = isset($data['allow_senders_to_set_recipient_email_language_metadata']) ? $data['allow_senders_to_set_recipient_email_language_metadata'] : null;
        $this->container['allow_signer_attachments'] = isset($data['allow_signer_attachments']) ? $data['allow_signer_attachments'] : null;
        $this->container['allow_signer_attachments_metadata'] = isset($data['allow_signer_attachments_metadata']) ? $data['allow_signer_attachments_metadata'] : null;
        $this->container['allow_supplemental_documents'] = isset($data['allow_supplemental_documents']) ? $data['allow_supplemental_documents'] : null;
        $this->container['allow_supplemental_documents_metadata'] = isset($data['allow_supplemental_documents_metadata']) ? $data['allow_supplemental_documents_metadata'] : null;
        $this->container['allow_tagging_in_send_and_correct'] = isset($data['allow_tagging_in_send_and_correct']) ? $data['allow_tagging_in_send_and_correct'] : null;
        $this->container['allow_tagging_in_send_and_correct_metadata'] = isset($data['allow_tagging_in_send_and_correct_metadata']) ? $data['allow_tagging_in_send_and_correct_metadata'] : null;
        $this->container['allow_vaulting'] = isset($data['allow_vaulting']) ? $data['allow_vaulting'] : null;
        $this->container['allow_vaulting_metadata'] = isset($data['allow_vaulting_metadata']) ? $data['allow_vaulting_metadata'] : null;
        $this->container['allow_wet_signing_override'] = isset($data['allow_wet_signing_override']) ? $data['allow_wet_signing_override'] : null;
        $this->container['allow_wet_signing_override_metadata'] = isset($data['allow_wet_signing_override_metadata']) ? $data['allow_wet_signing_override_metadata'] : null;
        $this->container['can_create_workspaces'] = isset($data['can_create_workspaces']) ? $data['can_create_workspaces'] : null;
        $this->container['can_create_workspaces_metadata'] = isset($data['can_create_workspaces_metadata']) ? $data['can_create_workspaces_metadata'] : null;
        $this->container['disable_document_upload'] = isset($data['disable_document_upload']) ? $data['disable_document_upload'] : null;
        $this->container['disable_document_upload_metadata'] = isset($data['disable_document_upload_metadata']) ? $data['disable_document_upload_metadata'] : null;
        $this->container['disable_other_actions'] = isset($data['disable_other_actions']) ? $data['disable_other_actions'] : null;
        $this->container['disable_other_actions_metadata'] = isset($data['disable_other_actions_metadata']) ? $data['disable_other_actions_metadata'] : null;
        $this->container['enable_api_request_logging'] = isset($data['enable_api_request_logging']) ? $data['enable_api_request_logging'] : null;
        $this->container['enable_api_request_logging_metadata'] = isset($data['enable_api_request_logging_metadata']) ? $data['enable_api_request_logging_metadata'] : null;
        $this->container['enable_recipient_viewing_notifications'] = isset($data['enable_recipient_viewing_notifications']) ? $data['enable_recipient_viewing_notifications'] : null;
        $this->container['enable_recipient_viewing_notifications_metadata'] = isset($data['enable_recipient_viewing_notifications_metadata']) ? $data['enable_recipient_viewing_notifications_metadata'] : null;
        $this->container['enable_sequential_signing_interface'] = isset($data['enable_sequential_signing_interface']) ? $data['enable_sequential_signing_interface'] : null;
        $this->container['enable_sequential_signing_interface_metadata'] = isset($data['enable_sequential_signing_interface_metadata']) ? $data['enable_sequential_signing_interface_metadata'] : null;
        $this->container['enable_transaction_point_integration'] = isset($data['enable_transaction_point_integration']) ? $data['enable_transaction_point_integration'] : null;
        $this->container['enable_transaction_point_integration_metadata'] = isset($data['enable_transaction_point_integration_metadata']) ? $data['enable_transaction_point_integration_metadata'] : null;
        $this->container['power_form_role'] = isset($data['power_form_role']) ? $data['power_form_role'] : null;
        $this->container['power_form_role_metadata'] = isset($data['power_form_role_metadata']) ? $data['power_form_role_metadata'] : null;
        $this->container['receive_completed_self_signed_documents_as_email_links'] = isset($data['receive_completed_self_signed_documents_as_email_links']) ? $data['receive_completed_self_signed_documents_as_email_links'] : null;
        $this->container['receive_completed_self_signed_documents_as_email_links_metadata'] = isset($data['receive_completed_self_signed_documents_as_email_links_metadata']) ? $data['receive_completed_self_signed_documents_as_email_links_metadata'] : null;
        $this->container['supplemental_documents_must_accept'] = isset($data['supplemental_documents_must_accept']) ? $data['supplemental_documents_must_accept'] : null;
        $this->container['supplemental_documents_must_accept_metadata'] = isset($data['supplemental_documents_must_accept_metadata']) ? $data['supplemental_documents_must_accept_metadata'] : null;
        $this->container['supplemental_documents_must_read'] = isset($data['supplemental_documents_must_read']) ? $data['supplemental_documents_must_read'] : null;
        $this->container['supplemental_documents_must_read_metadata'] = isset($data['supplemental_documents_must_read_metadata']) ? $data['supplemental_documents_must_read_metadata'] : null;
        $this->container['supplemental_documents_must_view'] = isset($data['supplemental_documents_must_view']) ? $data['supplemental_documents_must_view'] : null;
        $this->container['supplemental_documents_must_view_metadata'] = isset($data['supplemental_documents_must_view_metadata']) ? $data['supplemental_documents_must_view_metadata'] : null;
        $this->container['use_new_docu_sign_experience_interface'] = isset($data['use_new_docu_sign_experience_interface']) ? $data['use_new_docu_sign_experience_interface'] : null;
        $this->container['use_new_docu_sign_experience_interface_metadata'] = isset($data['use_new_docu_sign_experience_interface_metadata']) ? $data['use_new_docu_sign_experience_interface_metadata'] : null;
        $this->container['use_new_sending_interface'] = isset($data['use_new_sending_interface']) ? $data['use_new_sending_interface'] : null;
        $this->container['use_new_sending_interface_metadata'] = isset($data['use_new_sending_interface_metadata']) ? $data['use_new_sending_interface_metadata'] : null;
        $this->container['vaulting_mode'] = isset($data['vaulting_mode']) ? $data['vaulting_mode'] : null;
        $this->container['vaulting_mode_metadata'] = isset($data['vaulting_mode_metadata']) ? $data['vaulting_mode_metadata'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets allow_account_management
     * @return string
     */
    public function getAllowAccountManagement()
    {
        return $this->container['allow_account_management'];
    }

    /**
     * Sets allow_account_management
     * @param string $allow_account_management 
     * @return $this
     */
    public function setAllowAccountManagement($allow_account_management)
    {
        $this->container['allow_account_management'] = $allow_account_management;

        return $this;
    }

    /**
     * Gets allow_account_management_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowAccountManagementMetadata()
    {
        return $this->container['allow_account_management_metadata'];
    }

    /**
     * Sets allow_account_management_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_account_management_metadata
     * @return $this
     */
    public function setAllowAccountManagementMetadata($allow_account_management_metadata)
    {
        $this->container['allow_account_management_metadata'] = $allow_account_management_metadata;

        return $this;
    }

    /**
     * Gets allow_api_access
     * @return string
     */
    public function getAllowApiAccess()
    {
        return $this->container['allow_api_access'];
    }

    /**
     * Sets allow_api_access
     * @param string $allow_api_access 
     * @return $this
     */
    public function setAllowApiAccess($allow_api_access)
    {
        $this->container['allow_api_access'] = $allow_api_access;

        return $this;
    }

    /**
     * Gets allow_api_access_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiAccessMetadata()
    {
        return $this->container['allow_api_access_metadata'];
    }

    /**
     * Sets allow_api_access_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_access_metadata
     * @return $this
     */
    public function setAllowApiAccessMetadata($allow_api_access_metadata)
    {
        $this->container['allow_api_access_metadata'] = $allow_api_access_metadata;

        return $this;
    }

    /**
     * Gets allow_api_access_to_account
     * @return string
     */
    public function getAllowApiAccessToAccount()
    {
        return $this->container['allow_api_access_to_account'];
    }

    /**
     * Sets allow_api_access_to_account
     * @param string $allow_api_access_to_account 
     * @return $this
     */
    public function setAllowApiAccessToAccount($allow_api_access_to_account)
    {
        $this->container['allow_api_access_to_account'] = $allow_api_access_to_account;

        return $this;
    }

    /**
     * Gets allow_api_access_to_account_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiAccessToAccountMetadata()
    {
        return $this->container['allow_api_access_to_account_metadata'];
    }

    /**
     * Sets allow_api_access_to_account_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_access_to_account_metadata
     * @return $this
     */
    public function setAllowApiAccessToAccountMetadata($allow_api_access_to_account_metadata)
    {
        $this->container['allow_api_access_to_account_metadata'] = $allow_api_access_to_account_metadata;

        return $this;
    }

    /**
     * Gets allow_api_sending_on_behalf_of_others
     * @return string
     */
    public function getAllowApiSendingOnBehalfOfOthers()
    {
        return $this->container['allow_api_sending_on_behalf_of_others'];
    }

    /**
     * Sets allow_api_sending_on_behalf_of_others
     * @param string $allow_api_sending_on_behalf_of_others 
     * @return $this
     */
    public function setAllowApiSendingOnBehalfOfOthers($allow_api_sending_on_behalf_of_others)
    {
        $this->container['allow_api_sending_on_behalf_of_others'] = $allow_api_sending_on_behalf_of_others;

        return $this;
    }

    /**
     * Gets allow_api_sending_on_behalf_of_others_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiSendingOnBehalfOfOthersMetadata()
    {
        return $this->container['allow_api_sending_on_behalf_of_others_metadata'];
    }

    /**
     * Sets allow_api_sending_on_behalf_of_others_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_sending_on_behalf_of_others_metadata
     * @return $this
     */
    public function setAllowApiSendingOnBehalfOfOthersMetadata($allow_api_sending_on_behalf_of_others_metadata)
    {
        $this->container['allow_api_sending_on_behalf_of_others_metadata'] = $allow_api_sending_on_behalf_of_others_metadata;

        return $this;
    }

    /**
     * Gets allow_api_sequential_signing
     * @return string
     */
    public function getAllowApiSequentialSigning()
    {
        return $this->container['allow_api_sequential_signing'];
    }

    /**
     * Sets allow_api_sequential_signing
     * @param string $allow_api_sequential_signing 
     * @return $this
     */
    public function setAllowApiSequentialSigning($allow_api_sequential_signing)
    {
        $this->container['allow_api_sequential_signing'] = $allow_api_sequential_signing;

        return $this;
    }

    /**
     * Gets allow_api_sequential_signing_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowApiSequentialSigningMetadata()
    {
        return $this->container['allow_api_sequential_signing_metadata'];
    }

    /**
     * Sets allow_api_sequential_signing_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_api_sequential_signing_metadata
     * @return $this
     */
    public function setAllowApiSequentialSigningMetadata($allow_api_sequential_signing_metadata)
    {
        $this->container['allow_api_sequential_signing_metadata'] = $allow_api_sequential_signing_metadata;

        return $this;
    }

    /**
     * Gets allow_bulk_sending
     * @return string
     */
    public function getAllowBulkSending()
    {
        return $this->container['allow_bulk_sending'];
    }

    /**
     * Sets allow_bulk_sending
     * @param string $allow_bulk_sending 
     * @return $this
     */
    public function setAllowBulkSending($allow_bulk_sending)
    {
        $this->container['allow_bulk_sending'] = $allow_bulk_sending;

        return $this;
    }

    /**
     * Gets allow_bulk_sending_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowBulkSendingMetadata()
    {
        return $this->container['allow_bulk_sending_metadata'];
    }

    /**
     * Sets allow_bulk_sending_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_bulk_sending_metadata
     * @return $this
     */
    public function setAllowBulkSendingMetadata($allow_bulk_sending_metadata)
    {
        $this->container['allow_bulk_sending_metadata'] = $allow_bulk_sending_metadata;

        return $this;
    }

    /**
     * Gets allow_docu_sign_desktop_client
     * @return string
     */
    public function getAllowDocuSignDesktopClient()
    {
        return $this->container['allow_docu_sign_desktop_client'];
    }

    /**
     * Sets allow_docu_sign_desktop_client
     * @param string $allow_docu_sign_desktop_client 
     * @return $this
     */
    public function setAllowDocuSignDesktopClient($allow_docu_sign_desktop_client)
    {
        $this->container['allow_docu_sign_desktop_client'] = $allow_docu_sign_desktop_client;

        return $this;
    }

    /**
     * Gets allow_docu_sign_desktop_client_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowDocuSignDesktopClientMetadata()
    {
        return $this->container['allow_docu_sign_desktop_client_metadata'];
    }

    /**
     * Sets allow_docu_sign_desktop_client_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_docu_sign_desktop_client_metadata
     * @return $this
     */
    public function setAllowDocuSignDesktopClientMetadata($allow_docu_sign_desktop_client_metadata)
    {
        $this->container['allow_docu_sign_desktop_client_metadata'] = $allow_docu_sign_desktop_client_metadata;

        return $this;
    }

    /**
     * Gets allowed_address_book_access
     * @return string
     */
    public function getAllowedAddressBookAccess()
    {
        return $this->container['allowed_address_book_access'];
    }

    /**
     * Sets allowed_address_book_access
     * @param string $allowed_address_book_access 
     * @return $this
     */
    public function setAllowedAddressBookAccess($allowed_address_book_access)
    {
        $this->container['allowed_address_book_access'] = $allowed_address_book_access;

        return $this;
    }

    /**
     * Gets allowed_address_book_access_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedAddressBookAccessMetadata()
    {
        return $this->container['allowed_address_book_access_metadata'];
    }

    /**
     * Sets allowed_address_book_access_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_address_book_access_metadata
     * @return $this
     */
    public function setAllowedAddressBookAccessMetadata($allowed_address_book_access_metadata)
    {
        $this->container['allowed_address_book_access_metadata'] = $allowed_address_book_access_metadata;

        return $this;
    }

    /**
     * Gets allowed_template_access
     * @return string
     */
    public function getAllowedTemplateAccess()
    {
        return $this->container['allowed_template_access'];
    }

    /**
     * Sets allowed_template_access
     * @param string $allowed_template_access 
     * @return $this
     */
    public function setAllowedTemplateAccess($allowed_template_access)
    {
        $this->container['allowed_template_access'] = $allowed_template_access;

        return $this;
    }

    /**
     * Gets allowed_template_access_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedTemplateAccessMetadata()
    {
        return $this->container['allowed_template_access_metadata'];
    }

    /**
     * Sets allowed_template_access_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_template_access_metadata
     * @return $this
     */
    public function setAllowedTemplateAccessMetadata($allowed_template_access_metadata)
    {
        $this->container['allowed_template_access_metadata'] = $allowed_template_access_metadata;

        return $this;
    }

    /**
     * Gets allowed_to_be_envelope_transfer_recipient
     * @return string
     */
    public function getAllowedToBeEnvelopeTransferRecipient()
    {
        return $this->container['allowed_to_be_envelope_transfer_recipient'];
    }

    /**
     * Sets allowed_to_be_envelope_transfer_recipient
     * @param string $allowed_to_be_envelope_transfer_recipient 
     * @return $this
     */
    public function setAllowedToBeEnvelopeTransferRecipient($allowed_to_be_envelope_transfer_recipient)
    {
        $this->container['allowed_to_be_envelope_transfer_recipient'] = $allowed_to_be_envelope_transfer_recipient;

        return $this;
    }

    /**
     * Gets allowed_to_be_envelope_transfer_recipient_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowedToBeEnvelopeTransferRecipientMetadata()
    {
        return $this->container['allowed_to_be_envelope_transfer_recipient_metadata'];
    }

    /**
     * Sets allowed_to_be_envelope_transfer_recipient_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allowed_to_be_envelope_transfer_recipient_metadata
     * @return $this
     */
    public function setAllowedToBeEnvelopeTransferRecipientMetadata($allowed_to_be_envelope_transfer_recipient_metadata)
    {
        $this->container['allowed_to_be_envelope_transfer_recipient_metadata'] = $allowed_to_be_envelope_transfer_recipient_metadata;

        return $this;
    }

    /**
     * Gets allow_envelope_sending
     * @return string
     */
    public function getAllowEnvelopeSending()
    {
        return $this->container['allow_envelope_sending'];
    }

    /**
     * Sets allow_envelope_sending
     * @param string $allow_envelope_sending 
     * @return $this
     */
    public function setAllowEnvelopeSending($allow_envelope_sending)
    {
        $this->container['allow_envelope_sending'] = $allow_envelope_sending;

        return $this;
    }

    /**
     * Gets allow_envelope_sending_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowEnvelopeSendingMetadata()
    {
        return $this->container['allow_envelope_sending_metadata'];
    }

    /**
     * Sets allow_envelope_sending_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_envelope_sending_metadata
     * @return $this
     */
    public function setAllowEnvelopeSendingMetadata($allow_envelope_sending_metadata)
    {
        $this->container['allow_envelope_sending_metadata'] = $allow_envelope_sending_metadata;

        return $this;
    }

    /**
     * Gets allow_senders_to_set_recipient_email_language
     * @return string
     */
    public function getAllowSendersToSetRecipientEmailLanguage()
    {
        return $this->container['allow_senders_to_set_recipient_email_language'];
    }

    /**
     * Sets allow_senders_to_set_recipient_email_language
     * @param string $allow_senders_to_set_recipient_email_language 
     * @return $this
     */
    public function setAllowSendersToSetRecipientEmailLanguage($allow_senders_to_set_recipient_email_language)
    {
        $this->container['allow_senders_to_set_recipient_email_language'] = $allow_senders_to_set_recipient_email_language;

        return $this;
    }

    /**
     * Gets allow_senders_to_set_recipient_email_language_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSendersToSetRecipientEmailLanguageMetadata()
    {
        return $this->container['allow_senders_to_set_recipient_email_language_metadata'];
    }

    /**
     * Sets allow_senders_to_set_recipient_email_language_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_senders_to_set_recipient_email_language_metadata
     * @return $this
     */
    public function setAllowSendersToSetRecipientEmailLanguageMetadata($allow_senders_to_set_recipient_email_language_metadata)
    {
        $this->container['allow_senders_to_set_recipient_email_language_metadata'] = $allow_senders_to_set_recipient_email_language_metadata;

        return $this;
    }

    /**
     * Gets allow_signer_attachments
     * @return string
     */
    public function getAllowSignerAttachments()
    {
        return $this->container['allow_signer_attachments'];
    }

    /**
     * Sets allow_signer_attachments
     * @param string $allow_signer_attachments 
     * @return $this
     */
    public function setAllowSignerAttachments($allow_signer_attachments)
    {
        $this->container['allow_signer_attachments'] = $allow_signer_attachments;

        return $this;
    }

    /**
     * Gets allow_signer_attachments_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSignerAttachmentsMetadata()
    {
        return $this->container['allow_signer_attachments_metadata'];
    }

    /**
     * Sets allow_signer_attachments_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_signer_attachments_metadata
     * @return $this
     */
    public function setAllowSignerAttachmentsMetadata($allow_signer_attachments_metadata)
    {
        $this->container['allow_signer_attachments_metadata'] = $allow_signer_attachments_metadata;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents
     * @return string
     */
    public function getAllowSupplementalDocuments()
    {
        return $this->container['allow_supplemental_documents'];
    }

    /**
     * Sets allow_supplemental_documents
     * @param string $allow_supplemental_documents 
     * @return $this
     */
    public function setAllowSupplementalDocuments($allow_supplemental_documents)
    {
        $this->container['allow_supplemental_documents'] = $allow_supplemental_documents;

        return $this;
    }

    /**
     * Gets allow_supplemental_documents_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowSupplementalDocumentsMetadata()
    {
        return $this->container['allow_supplemental_documents_metadata'];
    }

    /**
     * Sets allow_supplemental_documents_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_supplemental_documents_metadata
     * @return $this
     */
    public function setAllowSupplementalDocumentsMetadata($allow_supplemental_documents_metadata)
    {
        $this->container['allow_supplemental_documents_metadata'] = $allow_supplemental_documents_metadata;

        return $this;
    }

    /**
     * Gets allow_tagging_in_send_and_correct
     * @return string
     */
    public function getAllowTaggingInSendAndCorrect()
    {
        return $this->container['allow_tagging_in_send_and_correct'];
    }

    /**
     * Sets allow_tagging_in_send_and_correct
     * @param string $allow_tagging_in_send_and_correct 
     * @return $this
     */
    public function setAllowTaggingInSendAndCorrect($allow_tagging_in_send_and_correct)
    {
        $this->container['allow_tagging_in_send_and_correct'] = $allow_tagging_in_send_and_correct;

        return $this;
    }

    /**
     * Gets allow_tagging_in_send_and_correct_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowTaggingInSendAndCorrectMetadata()
    {
        return $this->container['allow_tagging_in_send_and_correct_metadata'];
    }

    /**
     * Sets allow_tagging_in_send_and_correct_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_tagging_in_send_and_correct_metadata
     * @return $this
     */
    public function setAllowTaggingInSendAndCorrectMetadata($allow_tagging_in_send_and_correct_metadata)
    {
        $this->container['allow_tagging_in_send_and_correct_metadata'] = $allow_tagging_in_send_and_correct_metadata;

        return $this;
    }

    /**
     * Gets allow_vaulting
     * @return string
     */
    public function getAllowVaulting()
    {
        return $this->container['allow_vaulting'];
    }

    /**
     * Sets allow_vaulting
     * @param string $allow_vaulting 
     * @return $this
     */
    public function setAllowVaulting($allow_vaulting)
    {
        $this->container['allow_vaulting'] = $allow_vaulting;

        return $this;
    }

    /**
     * Gets allow_vaulting_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowVaultingMetadata()
    {
        return $this->container['allow_vaulting_metadata'];
    }

    /**
     * Sets allow_vaulting_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_vaulting_metadata
     * @return $this
     */
    public function setAllowVaultingMetadata($allow_vaulting_metadata)
    {
        $this->container['allow_vaulting_metadata'] = $allow_vaulting_metadata;

        return $this;
    }

    /**
     * Gets allow_wet_signing_override
     * @return string
     */
    public function getAllowWetSigningOverride()
    {
        return $this->container['allow_wet_signing_override'];
    }

    /**
     * Sets allow_wet_signing_override
     * @param string $allow_wet_signing_override 
     * @return $this
     */
    public function setAllowWetSigningOverride($allow_wet_signing_override)
    {
        $this->container['allow_wet_signing_override'] = $allow_wet_signing_override;

        return $this;
    }

    /**
     * Gets allow_wet_signing_override_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getAllowWetSigningOverrideMetadata()
    {
        return $this->container['allow_wet_signing_override_metadata'];
    }

    /**
     * Sets allow_wet_signing_override_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $allow_wet_signing_override_metadata
     * @return $this
     */
    public function setAllowWetSigningOverrideMetadata($allow_wet_signing_override_metadata)
    {
        $this->container['allow_wet_signing_override_metadata'] = $allow_wet_signing_override_metadata;

        return $this;
    }

    /**
     * Gets can_create_workspaces
     * @return string
     */
    public function getCanCreateWorkspaces()
    {
        return $this->container['can_create_workspaces'];
    }

    /**
     * Sets can_create_workspaces
     * @param string $can_create_workspaces 
     * @return $this
     */
    public function setCanCreateWorkspaces($can_create_workspaces)
    {
        $this->container['can_create_workspaces'] = $can_create_workspaces;

        return $this;
    }

    /**
     * Gets can_create_workspaces_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getCanCreateWorkspacesMetadata()
    {
        return $this->container['can_create_workspaces_metadata'];
    }

    /**
     * Sets can_create_workspaces_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $can_create_workspaces_metadata
     * @return $this
     */
    public function setCanCreateWorkspacesMetadata($can_create_workspaces_metadata)
    {
        $this->container['can_create_workspaces_metadata'] = $can_create_workspaces_metadata;

        return $this;
    }

    /**
     * Gets disable_document_upload
     * @return string
     */
    public function getDisableDocumentUpload()
    {
        return $this->container['disable_document_upload'];
    }

    /**
     * Sets disable_document_upload
     * @param string $disable_document_upload 
     * @return $this
     */
    public function setDisableDocumentUpload($disable_document_upload)
    {
        $this->container['disable_document_upload'] = $disable_document_upload;

        return $this;
    }

    /**
     * Gets disable_document_upload_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableDocumentUploadMetadata()
    {
        return $this->container['disable_document_upload_metadata'];
    }

    /**
     * Sets disable_document_upload_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_document_upload_metadata
     * @return $this
     */
    public function setDisableDocumentUploadMetadata($disable_document_upload_metadata)
    {
        $this->container['disable_document_upload_metadata'] = $disable_document_upload_metadata;

        return $this;
    }

    /**
     * Gets disable_other_actions
     * @return string
     */
    public function getDisableOtherActions()
    {
        return $this->container['disable_other_actions'];
    }

    /**
     * Sets disable_other_actions
     * @param string $disable_other_actions 
     * @return $this
     */
    public function setDisableOtherActions($disable_other_actions)
    {
        $this->container['disable_other_actions'] = $disable_other_actions;

        return $this;
    }

    /**
     * Gets disable_other_actions_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getDisableOtherActionsMetadata()
    {
        return $this->container['disable_other_actions_metadata'];
    }

    /**
     * Sets disable_other_actions_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $disable_other_actions_metadata
     * @return $this
     */
    public function setDisableOtherActionsMetadata($disable_other_actions_metadata)
    {
        $this->container['disable_other_actions_metadata'] = $disable_other_actions_metadata;

        return $this;
    }

    /**
     * Gets enable_api_request_logging
     * @return string
     */
    public function getEnableApiRequestLogging()
    {
        return $this->container['enable_api_request_logging'];
    }

    /**
     * Sets enable_api_request_logging
     * @param string $enable_api_request_logging 
     * @return $this
     */
    public function setEnableApiRequestLogging($enable_api_request_logging)
    {
        $this->container['enable_api_request_logging'] = $enable_api_request_logging;

        return $this;
    }

    /**
     * Gets enable_api_request_logging_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableApiRequestLoggingMetadata()
    {
        return $this->container['enable_api_request_logging_metadata'];
    }

    /**
     * Sets enable_api_request_logging_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_api_request_logging_metadata
     * @return $this
     */
    public function setEnableApiRequestLoggingMetadata($enable_api_request_logging_metadata)
    {
        $this->container['enable_api_request_logging_metadata'] = $enable_api_request_logging_metadata;

        return $this;
    }

    /**
     * Gets enable_recipient_viewing_notifications
     * @return string
     */
    public function getEnableRecipientViewingNotifications()
    {
        return $this->container['enable_recipient_viewing_notifications'];
    }

    /**
     * Sets enable_recipient_viewing_notifications
     * @param string $enable_recipient_viewing_notifications 
     * @return $this
     */
    public function setEnableRecipientViewingNotifications($enable_recipient_viewing_notifications)
    {
        $this->container['enable_recipient_viewing_notifications'] = $enable_recipient_viewing_notifications;

        return $this;
    }

    /**
     * Gets enable_recipient_viewing_notifications_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableRecipientViewingNotificationsMetadata()
    {
        return $this->container['enable_recipient_viewing_notifications_metadata'];
    }

    /**
     * Sets enable_recipient_viewing_notifications_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_recipient_viewing_notifications_metadata
     * @return $this
     */
    public function setEnableRecipientViewingNotificationsMetadata($enable_recipient_viewing_notifications_metadata)
    {
        $this->container['enable_recipient_viewing_notifications_metadata'] = $enable_recipient_viewing_notifications_metadata;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_interface
     * @return string
     */
    public function getEnableSequentialSigningInterface()
    {
        return $this->container['enable_sequential_signing_interface'];
    }

    /**
     * Sets enable_sequential_signing_interface
     * @param string $enable_sequential_signing_interface 
     * @return $this
     */
    public function setEnableSequentialSigningInterface($enable_sequential_signing_interface)
    {
        $this->container['enable_sequential_signing_interface'] = $enable_sequential_signing_interface;

        return $this;
    }

    /**
     * Gets enable_sequential_signing_interface_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableSequentialSigningInterfaceMetadata()
    {
        return $this->container['enable_sequential_signing_interface_metadata'];
    }

    /**
     * Sets enable_sequential_signing_interface_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_sequential_signing_interface_metadata
     * @return $this
     */
    public function setEnableSequentialSigningInterfaceMetadata($enable_sequential_signing_interface_metadata)
    {
        $this->container['enable_sequential_signing_interface_metadata'] = $enable_sequential_signing_interface_metadata;

        return $this;
    }

    /**
     * Gets enable_transaction_point_integration
     * @return string
     */
    public function getEnableTransactionPointIntegration()
    {
        return $this->container['enable_transaction_point_integration'];
    }

    /**
     * Sets enable_transaction_point_integration
     * @param string $enable_transaction_point_integration 
     * @return $this
     */
    public function setEnableTransactionPointIntegration($enable_transaction_point_integration)
    {
        $this->container['enable_transaction_point_integration'] = $enable_transaction_point_integration;

        return $this;
    }

    /**
     * Gets enable_transaction_point_integration_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getEnableTransactionPointIntegrationMetadata()
    {
        return $this->container['enable_transaction_point_integration_metadata'];
    }

    /**
     * Sets enable_transaction_point_integration_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $enable_transaction_point_integration_metadata
     * @return $this
     */
    public function setEnableTransactionPointIntegrationMetadata($enable_transaction_point_integration_metadata)
    {
        $this->container['enable_transaction_point_integration_metadata'] = $enable_transaction_point_integration_metadata;

        return $this;
    }

    /**
     * Gets power_form_role
     * @return string
     */
    public function getPowerFormRole()
    {
        return $this->container['power_form_role'];
    }

    /**
     * Sets power_form_role
     * @param string $power_form_role 
     * @return $this
     */
    public function setPowerFormRole($power_form_role)
    {
        $this->container['power_form_role'] = $power_form_role;

        return $this;
    }

    /**
     * Gets power_form_role_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getPowerFormRoleMetadata()
    {
        return $this->container['power_form_role_metadata'];
    }

    /**
     * Sets power_form_role_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $power_form_role_metadata
     * @return $this
     */
    public function setPowerFormRoleMetadata($power_form_role_metadata)
    {
        $this->container['power_form_role_metadata'] = $power_form_role_metadata;

        return $this;
    }

    /**
     * Gets receive_completed_self_signed_documents_as_email_links
     * @return string
     */
    public function getReceiveCompletedSelfSignedDocumentsAsEmailLinks()
    {
        return $this->container['receive_completed_self_signed_documents_as_email_links'];
    }

    /**
     * Sets receive_completed_self_signed_documents_as_email_links
     * @param string $receive_completed_self_signed_documents_as_email_links 
     * @return $this
     */
    public function setReceiveCompletedSelfSignedDocumentsAsEmailLinks($receive_completed_self_signed_documents_as_email_links)
    {
        $this->container['receive_completed_self_signed_documents_as_email_links'] = $receive_completed_self_signed_documents_as_email_links;

        return $this;
    }

    /**
     * Gets receive_completed_self_signed_documents_as_email_links_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata()
    {
        return $this->container['receive_completed_self_signed_documents_as_email_links_metadata'];
    }

    /**
     * Sets receive_completed_self_signed_documents_as_email_links_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $receive_completed_self_signed_documents_as_email_links_metadata
     * @return $this
     */
    public function setReceiveCompletedSelfSignedDocumentsAsEmailLinksMetadata($receive_completed_self_signed_documents_as_email_links_metadata)
    {
        $this->container['receive_completed_self_signed_documents_as_email_links_metadata'] = $receive_completed_self_signed_documents_as_email_links_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept
     * @return string
     */
    public function getSupplementalDocumentsMustAccept()
    {
        return $this->container['supplemental_documents_must_accept'];
    }

    /**
     * Sets supplemental_documents_must_accept
     * @param string $supplemental_documents_must_accept 
     * @return $this
     */
    public function setSupplementalDocumentsMustAccept($supplemental_documents_must_accept)
    {
        $this->container['supplemental_documents_must_accept'] = $supplemental_documents_must_accept;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_accept_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustAcceptMetadata()
    {
        return $this->container['supplemental_documents_must_accept_metadata'];
    }

    /**
     * Sets supplemental_documents_must_accept_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_accept_metadata
     * @return $this
     */
    public function setSupplementalDocumentsMustAcceptMetadata($supplemental_documents_must_accept_metadata)
    {
        $this->container['supplemental_documents_must_accept_metadata'] = $supplemental_documents_must_accept_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read
     * @return string
     */
    public function getSupplementalDocumentsMustRead()
    {
        return $this->container['supplemental_documents_must_read'];
    }

    /**
     * Sets supplemental_documents_must_read
     * @param string $supplemental_documents_must_read 
     * @return $this
     */
    public function setSupplementalDocumentsMustRead($supplemental_documents_must_read)
    {
        $this->container['supplemental_documents_must_read'] = $supplemental_documents_must_read;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_read_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustReadMetadata()
    {
        return $this->container['supplemental_documents_must_read_metadata'];
    }

    /**
     * Sets supplemental_documents_must_read_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_read_metadata
     * @return $this
     */
    public function setSupplementalDocumentsMustReadMetadata($supplemental_documents_must_read_metadata)
    {
        $this->container['supplemental_documents_must_read_metadata'] = $supplemental_documents_must_read_metadata;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view
     * @return string
     */
    public function getSupplementalDocumentsMustView()
    {
        return $this->container['supplemental_documents_must_view'];
    }

    /**
     * Sets supplemental_documents_must_view
     * @param string $supplemental_documents_must_view 
     * @return $this
     */
    public function setSupplementalDocumentsMustView($supplemental_documents_must_view)
    {
        $this->container['supplemental_documents_must_view'] = $supplemental_documents_must_view;

        return $this;
    }

    /**
     * Gets supplemental_documents_must_view_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getSupplementalDocumentsMustViewMetadata()
    {
        return $this->container['supplemental_documents_must_view_metadata'];
    }

    /**
     * Sets supplemental_documents_must_view_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $supplemental_documents_must_view_metadata
     * @return $this
     */
    public function setSupplementalDocumentsMustViewMetadata($supplemental_documents_must_view_metadata)
    {
        $this->container['supplemental_documents_must_view_metadata'] = $supplemental_documents_must_view_metadata;

        return $this;
    }

    /**
     * Gets use_new_docu_sign_experience_interface
     * @return string
     */
    public function getUseNewDocuSignExperienceInterface()
    {
        return $this->container['use_new_docu_sign_experience_interface'];
    }

    /**
     * Sets use_new_docu_sign_experience_interface
     * @param string $use_new_docu_sign_experience_interface 
     * @return $this
     */
    public function setUseNewDocuSignExperienceInterface($use_new_docu_sign_experience_interface)
    {
        $this->container['use_new_docu_sign_experience_interface'] = $use_new_docu_sign_experience_interface;

        return $this;
    }

    /**
     * Gets use_new_docu_sign_experience_interface_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewDocuSignExperienceInterfaceMetadata()
    {
        return $this->container['use_new_docu_sign_experience_interface_metadata'];
    }

    /**
     * Sets use_new_docu_sign_experience_interface_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_docu_sign_experience_interface_metadata
     * @return $this
     */
    public function setUseNewDocuSignExperienceInterfaceMetadata($use_new_docu_sign_experience_interface_metadata)
    {
        $this->container['use_new_docu_sign_experience_interface_metadata'] = $use_new_docu_sign_experience_interface_metadata;

        return $this;
    }

    /**
     * Gets use_new_sending_interface
     * @return string
     */
    public function getUseNewSendingInterface()
    {
        return $this->container['use_new_sending_interface'];
    }

    /**
     * Sets use_new_sending_interface
     * @param string $use_new_sending_interface 
     * @return $this
     */
    public function setUseNewSendingInterface($use_new_sending_interface)
    {
        $this->container['use_new_sending_interface'] = $use_new_sending_interface;

        return $this;
    }

    /**
     * Gets use_new_sending_interface_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getUseNewSendingInterfaceMetadata()
    {
        return $this->container['use_new_sending_interface_metadata'];
    }

    /**
     * Sets use_new_sending_interface_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $use_new_sending_interface_metadata
     * @return $this
     */
    public function setUseNewSendingInterfaceMetadata($use_new_sending_interface_metadata)
    {
        $this->container['use_new_sending_interface_metadata'] = $use_new_sending_interface_metadata;

        return $this;
    }

    /**
     * Gets vaulting_mode
     * @return string
     */
    public function getVaultingMode()
    {
        return $this->container['vaulting_mode'];
    }

    /**
     * Sets vaulting_mode
     * @param string $vaulting_mode 
     * @return $this
     */
    public function setVaultingMode($vaulting_mode)
    {
        $this->container['vaulting_mode'] = $vaulting_mode;

        return $this;
    }

    /**
     * Gets vaulting_mode_metadata
     * @return \DocuSign\eSign\Model\SettingsMetadata
     */
    public function getVaultingModeMetadata()
    {
        return $this->container['vaulting_mode_metadata'];
    }

    /**
     * Sets vaulting_mode_metadata
     * @param \DocuSign\eSign\Model\SettingsMetadata $vaulting_mode_metadata
     * @return $this
     */
    public function setVaultingModeMetadata($vaulting_mode_metadata)
    {
        $this->container['vaulting_mode_metadata'] = $vaulting_mode_metadata;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


