<?php
/**
 * AccountsApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\AccountsApi;

class CreateOptions
{
    /**
      * $preview_billing_plan When set to **true**, creates the account using a preview billing plan.
      * @var string
      */
    protected $preview_billing_plan;

    /**
     * Gets preview_billing_plan
     * @return string
     */
    public function getPreviewBillingPlan()
    {
        return $this->preview_billing_plan;
    }
  
    /**
     * Sets preview_billing_plan
     * @param string $preview_billing_plan When set to **true**, creates the account using a preview billing plan.
     * @return $this
     */
    public function setPreviewBillingPlan($preview_billing_plan)
    {
        $this->preview_billing_plan = $preview_billing_plan;
        return $this;
    }
}
class CreatePermissionProfileOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class GetAccountInformationOptions
{
    /**
      * $include_account_settings When set to **true**, includes the account settings for the account in the response.
      * @var string
      */
    protected $include_account_settings;

    /**
     * Gets include_account_settings
     * @return string
     */
    public function getIncludeAccountSettings()
    {
        return $this->include_account_settings;
    }
  
    /**
     * Sets include_account_settings
     * @param string $include_account_settings When set to **true**, includes the account settings for the account in the response.
     * @return $this
     */
    public function setIncludeAccountSettings($include_account_settings)
    {
        $this->include_account_settings = $include_account_settings;
        return $this;
    }
}
class GetBillingChargesOptions
{
    /**
      * $include_charges Specifies which billing charges to return. Valid values are:  * envelopes * seats
      * @var string
      */
    protected $include_charges;

    /**
     * Gets include_charges
     * @return string
     */
    public function getIncludeCharges()
    {
        return $this->include_charges;
    }
  
    /**
     * Sets include_charges
     * @param string $include_charges Specifies which billing charges to return. Valid values are:  * envelopes * seats
     * @return $this
     */
    public function setIncludeCharges($include_charges)
    {
        $this->include_charges = $include_charges;
        return $this;
    }
}
class GetBrandOptions
{
    /**
      * $include_external_references 
      * @var string
      */
    protected $include_external_references;

    /**
     * Gets include_external_references
     * @return string
     */
    public function getIncludeExternalReferences()
    {
        return $this->include_external_references;
    }
  
    /**
     * Sets include_external_references
     * @param string $include_external_references 
     * @return $this
     */
    public function setIncludeExternalReferences($include_external_references)
    {
        $this->include_external_references = $include_external_references;
        return $this;
    }
    /**
      * $include_logos 
      * @var string
      */
    protected $include_logos;

    /**
     * Gets include_logos
     * @return string
     */
    public function getIncludeLogos()
    {
        return $this->include_logos;
    }
  
    /**
     * Sets include_logos
     * @param string $include_logos 
     * @return $this
     */
    public function setIncludeLogos($include_logos)
    {
        $this->include_logos = $include_logos;
        return $this;
    }
}
class GetBrandResourcesByContentTypeOptions
{
    /**
      * $langcode 
      * @var string
      */
    protected $langcode;

    /**
     * Gets langcode
     * @return string
     */
    public function getLangcode()
    {
        return $this->langcode;
    }
  
    /**
     * Sets langcode
     * @param string $langcode 
     * @return $this
     */
    public function setLangcode($langcode)
    {
        $this->langcode = $langcode;
        return $this;
    }
    /**
      * $return_master 
      * @var string
      */
    protected $return_master;

    /**
     * Gets return_master
     * @return string
     */
    public function getReturnMaster()
    {
        return $this->return_master;
    }
  
    /**
     * Sets return_master
     * @param string $return_master 
     * @return $this
     */
    public function setReturnMaster($return_master)
    {
        $this->return_master = $return_master;
        return $this;
    }
}
class GetConsumerDisclosureDefaultOptions
{
    /**
      * $lang_code Specifies the language used in the response. The supported languages, with the language value shown in parenthesis, are: Arabic (ar), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk), and Vietnamese (vi).  Additionally, the value can be set to `browser` to automatically detect the browser language being used by the viewer and display the disclosure in that language.
      * @var string
      */
    protected $lang_code;

    /**
     * Gets lang_code
     * @return string
     */
    public function getLangCode()
    {
        return $this->lang_code;
    }
  
    /**
     * Sets lang_code
     * @param string $lang_code Specifies the language used in the response. The supported languages, with the language value shown in parenthesis, are: Arabic (ar), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk), and Vietnamese (vi).  Additionally, the value can be set to `browser` to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @return $this
     */
    public function setLangCode($lang_code)
    {
        $this->lang_code = $lang_code;
        return $this;
    }
}
class GetPermissionProfileOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class ListBrandsOptions
{
    /**
      * $exclude_distributor_brand When set to **true**, excludes distributor brand information from the response set.
      * @var string
      */
    protected $exclude_distributor_brand;

    /**
     * Gets exclude_distributor_brand
     * @return string
     */
    public function getExcludeDistributorBrand()
    {
        return $this->exclude_distributor_brand;
    }
  
    /**
     * Sets exclude_distributor_brand
     * @param string $exclude_distributor_brand When set to **true**, excludes distributor brand information from the response set.
     * @return $this
     */
    public function setExcludeDistributorBrand($exclude_distributor_brand)
    {
        $this->exclude_distributor_brand = $exclude_distributor_brand;
        return $this;
    }
    /**
      * $include_logos When set to **true**, returns the logos associated with the brand.
      * @var string
      */
    protected $include_logos;

    /**
     * Gets include_logos
     * @return string
     */
    public function getIncludeLogos()
    {
        return $this->include_logos;
    }
  
    /**
     * Sets include_logos
     * @param string $include_logos When set to **true**, returns the logos associated with the brand.
     * @return $this
     */
    public function setIncludeLogos($include_logos)
    {
        $this->include_logos = $include_logos;
        return $this;
    }
}
class ListPermissionsOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class ListRecipientNamesByEmailOptions
{
    /**
      * $email The email address for the user
      * @var string
      */
    protected $email;

    /**
     * Gets email
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }
  
    /**
     * Sets email
     * @param string $email The email address for the user
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }
}
class ListSharedAccessOptions
{
    /**
      * $count Specifies maximum number of results included in the response. If no value is specified, this defaults to 1000.
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count Specifies maximum number of results included in the response. If no value is specified, this defaults to 1000.
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $envelopes_not_shared_user_status 
      * @var string
      */
    protected $envelopes_not_shared_user_status;

    /**
     * Gets envelopes_not_shared_user_status
     * @return string
     */
    public function getEnvelopesNotSharedUserStatus()
    {
        return $this->envelopes_not_shared_user_status;
    }
  
    /**
     * Sets envelopes_not_shared_user_status
     * @param string $envelopes_not_shared_user_status 
     * @return $this
     */
    public function setEnvelopesNotSharedUserStatus($envelopes_not_shared_user_status)
    {
        $this->envelopes_not_shared_user_status = $envelopes_not_shared_user_status;
        return $this;
    }
    /**
      * $folder_ids 
      * @var string
      */
    protected $folder_ids;

    /**
     * Gets folder_ids
     * @return string
     */
    public function getFolderIds()
    {
        return $this->folder_ids;
    }
  
    /**
     * Sets folder_ids
     * @param string $folder_ids 
     * @return $this
     */
    public function setFolderIds($folder_ids)
    {
        $this->folder_ids = $folder_ids;
        return $this;
    }
    /**
      * $item_type Specifies the type of shared item being requested. The accepted values are: -envelopes: returns information about envelope sharing between users.
      * @var string
      */
    protected $item_type;

    /**
     * Gets item_type
     * @return string
     */
    public function getItemType()
    {
        return $this->item_type;
    }
  
    /**
     * Sets item_type
     * @param string $item_type Specifies the type of shared item being requested. The accepted values are: -envelopes: returns information about envelope sharing between users.
     * @return $this
     */
    public function setItemType($item_type)
    {
        $this->item_type = $item_type;
        return $this;
    }
    /**
      * $search_text This can be used to filter user names in the response. The wild-card ‘*’ (asterisk) can be used around the string.
      * @var string
      */
    protected $search_text;

    /**
     * Gets search_text
     * @return string
     */
    public function getSearchText()
    {
        return $this->search_text;
    }
  
    /**
     * Sets search_text
     * @param string $search_text This can be used to filter user names in the response. The wild-card ‘*’ (asterisk) can be used around the string.
     * @return $this
     */
    public function setSearchText($search_text)
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $shared Specifies which users should be included in the response. Multiple values can be used in the query by using a comma separated list of shared values. If the requestor does not have account administrator privileges, the shared_to value is used. Requestors that do not have account administrator privileges can only use the shared_to, any other setting will result in an error. The accepted values are:  -not_shared: Returns account users that the specified item type is not being shared with and that are not sharing the specified item type with the user.  User X (Share) X Account user  -shared_to: Returns account users that the specified item type is not being shared with and who are sharing the specified item type with the user (only shared to the user).  User X (Share) Account user  -shared_from: Returns account users that the specified item type is being shared with and who are not sharing the specified item type with the user (only shared from the user).  User (Share) >> Account user  -shared_to_and_from: Returns account users that the specified item type is being shared with and who are sharing the specified item type with the user.  User << (Share) >> Account user
      * @var string
      */
    protected $shared;

    /**
     * Gets shared
     * @return string
     */
    public function getShared()
    {
        return $this->shared;
    }
  
    /**
     * Sets shared
     * @param string $shared Specifies which users should be included in the response. Multiple values can be used in the query by using a comma separated list of shared values. If the requestor does not have account administrator privileges, the shared_to value is used. Requestors that do not have account administrator privileges can only use the shared_to, any other setting will result in an error. The accepted values are:  -not_shared: Returns account users that the specified item type is not being shared with and that are not sharing the specified item type with the user.  User X (Share) X Account user  -shared_to: Returns account users that the specified item type is not being shared with and who are sharing the specified item type with the user (only shared to the user).  User X (Share) Account user  -shared_from: Returns account users that the specified item type is being shared with and who are not sharing the specified item type with the user (only shared from the user).  User (Share) >> Account user  -shared_to_and_from: Returns account users that the specified item type is being shared with and who are sharing the specified item type with the user.  User << (Share) >> Account user
     * @return $this
     */
    public function setShared($shared)
    {
        $this->shared = $shared;
        return $this;
    }
    /**
      * $start_position If the response set exceeds Count, this can be used to specify that the method should return users starting at the specified index. The first index is 0, and should be used in the first GET call. Typically this number is a multiple of Count. If no value is specified, this defaults to be 0.
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position If the response set exceeds Count, this can be used to specify that the method should return users starting at the specified index. The first index is 0, and should be used in the first GET call. Typically this number is a multiple of Count. If no value is specified, this defaults to be 0.
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $user_ids A comma separated list of userIds for whom the shared item information is being requested.
      * @var string
      */
    protected $user_ids;

    /**
     * Gets user_ids
     * @return string
     */
    public function getUserIds()
    {
        return $this->user_ids;
    }
  
    /**
     * Sets user_ids
     * @param string $user_ids A comma separated list of userIds for whom the shared item information is being requested.
     * @return $this
     */
    public function setUserIds($user_ids)
    {
        $this->user_ids = $user_ids;
        return $this;
    }
}
class UpdatePermissionProfileOptions
{
    /**
      * $include 
      * @var string
      */
    protected $include;

    /**
     * Gets include
     * @return string
     */
    public function getInclude()
    {
        return $this->include;
    }
  
    /**
     * Sets include
     * @param string $include 
     * @return $this
     */
    public function setInclude($include)
    {
        $this->include = $include;
        return $this;
    }
}
class UpdateSharedAccessOptions
{
    /**
      * $item_type 
      * @var string
      */
    protected $item_type;

    /**
     * Gets item_type
     * @return string
     */
    public function getItemType()
    {
        return $this->item_type;
    }
  
    /**
     * Sets item_type
     * @param string $item_type 
     * @return $this
     */
    public function setItemType($item_type)
    {
        $this->item_type = $item_type;
        return $this;
    }
    /**
      * $user_ids 
      * @var string
      */
    protected $user_ids;

    /**
     * Gets user_ids
     * @return string
     */
    public function getUserIds()
    {
        return $this->user_ids;
    }
  
    /**
     * Sets user_ids
     * @param string $user_ids 
     * @return $this
     */
    public function setUserIds($user_ids)
    {
        $this->user_ids = $user_ids;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * AccountsApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class AccountsApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return AccountsApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation create
     *
     * Creates new accounts.
     *
     * @param \DocuSign\eSign\Model\NewAccountDefinition $new_account_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\NewAccountSummary
     */
    public function create($new_account_definition = null, AccountsApi\CreateOptions $options = null)
    {
        list($response) = $this->createWithHttpInfo($new_account_definition, $options);
        return $response;
    }

    /**
     * Operation createWithHttpInfo
     *
     * Creates new accounts.
     *
     * @param \DocuSign\eSign\Model\NewAccountDefinition $new_account_definition  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\NewAccountSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWithHttpInfo($new_account_definition = null, AccountsApi\CreateOptions $options = null)
    {
        // parse inputs
        $resourcePath = "/v2/accounts";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getPreviewBillingPlan() !== null) {
            $queryParams['preview_billing_plan'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreviewBillingPlan());
        }
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($new_account_definition)) {
            $_tempBody = $new_account_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\NewAccountSummary',
                '/v2/accounts'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\NewAccountSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\NewAccountSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createBrand
     *
     * Creates one or more brand profile files for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function createBrand($account_id, $brand = null)
    {
        list($response) = $this->createBrandWithHttpInfo($account_id, $brand);
        return $response;
    }

    /**
     * Operation createBrandWithHttpInfo
     *
     * Creates one or more brand profile files for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBrandWithHttpInfo($account_id, $brand = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createBrand');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brand)) {
            $_tempBody = $brand;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2/accounts/{accountId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEMortgageTransaction
     *
     * Starts a new eMortgage Transaction
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PostTransactionsRequest $post_transactions_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PostTransactionsResponse
     */
    public function createEMortgageTransaction($account_id, $post_transactions_request = null)
    {
        list($response) = $this->createEMortgageTransactionWithHttpInfo($account_id, $post_transactions_request);
        return $response;
    }

    /**
     * Operation createEMortgageTransactionWithHttpInfo
     *
     * Starts a new eMortgage Transaction
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PostTransactionsRequest $post_transactions_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PostTransactionsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEMortgageTransactionWithHttpInfo($account_id, $post_transactions_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEMortgageTransaction');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/eMortgage/transactions";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($post_transactions_request)) {
            $_tempBody = $post_transactions_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PostTransactionsResponse',
                '/v2/accounts/{accountId}/eMortgage/transactions'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PostTransactionsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PostTransactionsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createPermissionProfile
     *
     * Creates a new permission profile in the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfile
     */
    public function createPermissionProfile($account_id, $permission_profile = null, AccountsApi\CreatePermissionProfileOptions $options = null)
    {
        list($response) = $this->createPermissionProfileWithHttpInfo($account_id, $permission_profile, $options);
        return $response;
    }

    /**
     * Operation createPermissionProfileWithHttpInfo
     *
     * Creates a new permission profile in the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPermissionProfileWithHttpInfo($account_id, $permission_profile = null, AccountsApi\CreatePermissionProfileOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createPermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/permission_profiles";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($permission_profile)) {
            $_tempBody = $permission_profile;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfile',
                '/v2/accounts/{accountId}/permission_profiles'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation delete
     *
     * Deletes the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function delete($account_id)
    {
        list($response) = $this->deleteWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation deleteWithHttpInfo
     *
     * Deletes the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling delete');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrand
     *
     * Removes a brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteBrand($account_id, $brand_id)
    {
        list($response) = $this->deleteBrandWithHttpInfo($account_id, $brand_id);
        return $response;
    }

    /**
     * Operation deleteBrandWithHttpInfo
     *
     * Removes a brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandWithHttpInfo($account_id, $brand_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrand');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrand');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/brands/{brandId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrandLogoByType
     *
     * Delete one branding logo.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $logo_type One of **Primary**, **Secondary** or **Email**.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteBrandLogoByType($account_id, $brand_id, $logo_type)
    {
        list($response) = $this->deleteBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type);
        return $response;
    }

    /**
     * Operation deleteBrandLogoByTypeWithHttpInfo
     *
     * Delete one branding logo.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $logo_type One of **Primary**, **Secondary** or **Email**.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrandLogoByType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling deleteBrandLogoByType');
        }
        // verify the required parameter 'logo_type' is set
        if ($logo_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_type when calling deleteBrandLogoByType');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // path params
        if ($logo_type !== null) {
            $resourcePath = str_replace(
                "{" . "logoType" . "}",
                $this->apiClient->getSerializer()->toPathValue($logo_type),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrands
     *
     * Deletes one or more brand profiles.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function deleteBrands($account_id, $brands_request = null)
    {
        list($response) = $this->deleteBrandsWithHttpInfo($account_id, $brands_request);
        return $response;
    }

    /**
     * Operation deleteBrandsWithHttpInfo
     *
     * Deletes one or more brand profiles.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandsWithHttpInfo($account_id, $brands_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrands');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brands_request)) {
            $_tempBody = $brands_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2/accounts/{accountId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCaptiveRecipient
     *
     * Deletes the signature for one or more captive recipient records.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_part 
     * @param \DocuSign\eSign\Model\CaptiveRecipientInformation $captive_recipient_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CaptiveRecipientInformation
     */
    public function deleteCaptiveRecipient($account_id, $recipient_part, $captive_recipient_information = null)
    {
        list($response) = $this->deleteCaptiveRecipientWithHttpInfo($account_id, $recipient_part, $captive_recipient_information);
        return $response;
    }

    /**
     * Operation deleteCaptiveRecipientWithHttpInfo
     *
     * Deletes the signature for one or more captive recipient records.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $recipient_part 
     * @param \DocuSign\eSign\Model\CaptiveRecipientInformation $captive_recipient_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CaptiveRecipientInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCaptiveRecipientWithHttpInfo($account_id, $recipient_part, $captive_recipient_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCaptiveRecipient');
        }
        // verify the required parameter 'recipient_part' is set
        if ($recipient_part === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_part when calling deleteCaptiveRecipient');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/captive_recipients/{recipientPart}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($recipient_part !== null) {
            $resourcePath = str_replace(
                "{" . "recipientPart" . "}",
                $this->apiClient->getSerializer()->toPathValue($recipient_part),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($captive_recipient_information)) {
            $_tempBody = $captive_recipient_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CaptiveRecipientInformation',
                '/v2/accounts/{accountId}/captive_recipients/{recipientPart}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CaptiveRecipientInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CaptiveRecipientInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteENoteConfiguration
     *
     * Deletes configuration information for the eNote eOriginal integration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteENoteConfiguration($account_id)
    {
        list($response) = $this->deleteENoteConfigurationWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation deleteENoteConfigurationWithHttpInfo
     *
     * Deletes configuration information for the eNote eOriginal integration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteENoteConfigurationWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteENoteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings/enote_configuration";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/settings/enote_configuration'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deletePermissionProfile
     *
     * Deletes a permissions profile within the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $permission_profile_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deletePermissionProfile($account_id, $permission_profile_id)
    {
        list($response) = $this->deletePermissionProfileWithHttpInfo($account_id, $permission_profile_id);
        return $response;
    }

    /**
     * Operation deletePermissionProfileWithHttpInfo
     *
     * Deletes a permissions profile within the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $permission_profile_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deletePermissionProfileWithHttpInfo($account_id, $permission_profile_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deletePermissionProfile');
        }
        // verify the required parameter 'permission_profile_id' is set
        if ($permission_profile_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $permission_profile_id when calling deletePermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($permission_profile_id !== null) {
            $resourcePath = str_replace(
                "{" . "permissionProfileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($permission_profile_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountInformation
     *
     * Retrieves the account information for the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountInformation
     */
    public function getAccountInformation($account_id, AccountsApi\GetAccountInformationOptions $options = null)
    {
        list($response) = $this->getAccountInformationWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getAccountInformationWithHttpInfo
     *
     * Retrieves the account information for the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountInformationWithHttpInfo($account_id, AccountsApi\GetAccountInformationOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountInformation');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeAccountSettings() !== null) {
            $queryParams['include_account_settings'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAccountSettings());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountInformation',
                '/v2/accounts/{accountId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAccountTabSettings
     *
     * Returns tab settings list for specified account
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TabAccountSettings
     */
    public function getAccountTabSettings($account_id)
    {
        list($response) = $this->getAccountTabSettingsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getAccountTabSettingsWithHttpInfo
     *
     * Returns tab settings list for specified account
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TabAccountSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAccountTabSettingsWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAccountTabSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TabAccountSettings',
                '/v2/accounts/{accountId}/settings/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TabAccountSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TabAccountSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBillingCharges
     *
     * Gets list of recurring and usage charges for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingChargeResponse
     */
    public function getBillingCharges($account_id, AccountsApi\GetBillingChargesOptions $options = null)
    {
        list($response) = $this->getBillingChargesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getBillingChargesWithHttpInfo
     *
     * Gets list of recurring and usage charges for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingChargeResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBillingChargesWithHttpInfo($account_id, AccountsApi\GetBillingChargesOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBillingCharges');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_charges";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeCharges() !== null) {
            $queryParams['include_charges'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeCharges());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingChargeResponse',
                '/v2/accounts/{accountId}/billing_charges'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingChargeResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingChargeResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrand
     *
     * Get information for a specific brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Brand
     */
    public function getBrand($account_id, $brand_id, AccountsApi\GetBrandOptions $options = null)
    {
        list($response) = $this->getBrandWithHttpInfo($account_id, $brand_id, $options);
        return $response;
    }

    /**
     * Operation getBrandWithHttpInfo
     *
     * Get information for a specific brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Brand, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandWithHttpInfo($account_id, $brand_id, AccountsApi\GetBrandOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrand');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrand');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeExternalReferences() !== null) {
            $queryParams['include_external_references'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeExternalReferences());
        }
        // query params
        if ($options->getIncludeLogos() !== null) {
            $queryParams['include_logos'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeLogos());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Brand',
                '/v2/accounts/{accountId}/brands/{brandId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Brand', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Brand', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandLogoByType
     *
     * Obtains the specified image for a brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $logo_type One of **Primary**, **Secondary** or **Email**.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function getBrandLogoByType($account_id, $brand_id, $logo_type)
    {
        list($response) = $this->getBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type);
        return $response;
    }

    /**
     * Operation getBrandLogoByTypeWithHttpInfo
     *
     * Obtains the specified image for a brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $logo_type One of **Primary**, **Secondary** or **Email**.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandLogoByType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandLogoByType');
        }
        // verify the required parameter 'logo_type' is set
        if ($logo_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_type when calling getBrandLogoByType');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // path params
        if ($logo_type !== null) {
            $resourcePath = str_replace(
                "{" . "logoType" . "}",
                $this->apiClient->getSerializer()->toPathValue($logo_type),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandResources
     *
     * Returns the specified account's list of branding resources (metadata).
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandResourcesList
     */
    public function getBrandResources($account_id, $brand_id)
    {
        list($response) = $this->getBrandResourcesWithHttpInfo($account_id, $brand_id);
        return $response;
    }

    /**
     * Operation getBrandResourcesWithHttpInfo
     *
     * Returns the specified account's list of branding resources (metadata).
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandResourcesList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandResourcesWithHttpInfo($account_id, $brand_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandResources');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandResources');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}/resources";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandResourcesList',
                '/v2/accounts/{accountId}/brands/{brandId}/resources'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandResourcesList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandResourcesList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrandResourcesByContentType
     *
     * Returns the specified branding resource file.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $resource_content_type 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function getBrandResourcesByContentType($account_id, $brand_id, $resource_content_type, AccountsApi\GetBrandResourcesByContentTypeOptions $options = null)
    {
        list($response) = $this->getBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type, $options);
        return $response;
    }

    /**
     * Operation getBrandResourcesByContentTypeWithHttpInfo
     *
     * Returns the specified branding resource file.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $resource_content_type 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type, AccountsApi\GetBrandResourcesByContentTypeOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrandResourcesByContentType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling getBrandResourcesByContentType');
        }
        // verify the required parameter 'resource_content_type' is set
        if ($resource_content_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $resource_content_type when calling getBrandResourcesByContentType');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getLangcode() !== null) {
            $queryParams['langcode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangcode());
        }
        // query params
        if ($options->getReturnMaster() !== null) {
            $queryParams['return_master'] = $this->apiClient->getSerializer()->toQueryValue($options->getReturnMaster());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // path params
        if ($resource_content_type !== null) {
            $resourcePath = str_replace(
                "{" . "resourceContentType" . "}",
                $this->apiClient->getSerializer()->toPathValue($resource_content_type),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosure
     *
     * Gets the Electronic Record and Signature Disclosure.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to �browser� to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosure($account_id, $lang_code)
    {
        list($response) = $this->getConsumerDisclosureWithHttpInfo($account_id, $lang_code);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureWithHttpInfo
     *
     * Gets the Electronic Record and Signature Disclosure.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to �browser� to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureWithHttpInfo($account_id, $lang_code)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosure');
        }
        // verify the required parameter 'lang_code' is set
        if ($lang_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lang_code when calling getConsumerDisclosure');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/consumer_disclosure/{langCode}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($lang_code !== null) {
            $resourcePath = str_replace(
                "{" . "langCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($lang_code),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2/accounts/{accountId}/consumer_disclosure/{langCode}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosureDefault
     *
     * Gets the Electronic Record and Signature Disclosure for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosureDefault($account_id, AccountsApi\GetConsumerDisclosureDefaultOptions $options = null)
    {
        list($response) = $this->getConsumerDisclosureDefaultWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureDefaultWithHttpInfo
     *
     * Gets the Electronic Record and Signature Disclosure for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureDefaultWithHttpInfo($account_id, AccountsApi\GetConsumerDisclosureDefaultOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosureDefault');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/consumer_disclosure";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getLangCode() !== null) {
            $queryParams['langCode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangCode());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2/accounts/{accountId}/consumer_disclosure'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getENoteConfiguration
     *
     * Returns the configuration information for the eNote eOriginal integration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ENoteConfiguration
     */
    public function getENoteConfiguration($account_id)
    {
        list($response) = $this->getENoteConfigurationWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation getENoteConfigurationWithHttpInfo
     *
     * Returns the configuration information for the eNote eOriginal integration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ENoteConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function getENoteConfigurationWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getENoteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings/enote_configuration";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ENoteConfiguration',
                '/v2/accounts/{accountId}/settings/enote_configuration'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ENoteConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ENoteConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPermissionProfile
     *
     * Returns a permissions profile in the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $permission_profile_id 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfile
     */
    public function getPermissionProfile($account_id, $permission_profile_id, AccountsApi\GetPermissionProfileOptions $options = null)
    {
        list($response) = $this->getPermissionProfileWithHttpInfo($account_id, $permission_profile_id, $options);
        return $response;
    }

    /**
     * Operation getPermissionProfileWithHttpInfo
     *
     * Returns a permissions profile in the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $permission_profile_id 
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPermissionProfileWithHttpInfo($account_id, $permission_profile_id, AccountsApi\GetPermissionProfileOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPermissionProfile');
        }
        // verify the required parameter 'permission_profile_id' is set
        if ($permission_profile_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $permission_profile_id when calling getPermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($permission_profile_id !== null) {
            $resourcePath = str_replace(
                "{" . "permissionProfileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($permission_profile_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfile',
                '/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getProvisioning
     *
     * Retrieves the account provisioning information for the account.
     *
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ProvisioningInformation
     */
    public function getProvisioning()
    {
        list($response) = $this->getProvisioningWithHttpInfo();
        return $response;
    }

    /**
     * Operation getProvisioningWithHttpInfo
     *
     * Retrieves the account provisioning information for the account.
     *
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ProvisioningInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getProvisioningWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/v2/accounts/provisioning";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ProvisioningInformation',
                '/v2/accounts/provisioning'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ProvisioningInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ProvisioningInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listBrands
     *
     * Gets a list of brand profiles.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function listBrands($account_id, AccountsApi\ListBrandsOptions $options = null)
    {
        list($response) = $this->listBrandsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listBrandsWithHttpInfo
     *
     * Gets a list of brand profiles.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBrandsWithHttpInfo($account_id, AccountsApi\ListBrandsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listBrands');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getExcludeDistributorBrand() !== null) {
            $queryParams['exclude_distributor_brand'] = $this->apiClient->getSerializer()->toQueryValue($options->getExcludeDistributorBrand());
        }
        // query params
        if ($options->getIncludeLogos() !== null) {
            $queryParams['include_logos'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeLogos());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2/accounts/{accountId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomFields
     *
     * Gets a list of custom fields associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function listCustomFields($account_id)
    {
        list($response) = $this->listCustomFieldsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listCustomFieldsWithHttpInfo
     *
     * Gets a list of custom fields associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomFieldsWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/custom_fields";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2/accounts/{accountId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPermissions
     *
     * Gets a list of permission profiles.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfileInformation
     */
    public function listPermissions($account_id, AccountsApi\ListPermissionsOptions $options = null)
    {
        list($response) = $this->listPermissionsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listPermissionsWithHttpInfo
     *
     * Gets a list of permission profiles.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfileInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPermissionsWithHttpInfo($account_id, AccountsApi\ListPermissionsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listPermissions');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/permission_profiles";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfileInformation',
                '/v2/accounts/{accountId}/permission_profiles'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfileInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfileInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listRecipientNamesByEmail
     *
     * Gets recipient names associated with an email address.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\RecipientNamesResponse
     */
    public function listRecipientNamesByEmail($account_id, AccountsApi\ListRecipientNamesByEmailOptions $options = null)
    {
        list($response) = $this->listRecipientNamesByEmailWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listRecipientNamesByEmailWithHttpInfo
     *
     * Gets recipient names associated with an email address.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\RecipientNamesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRecipientNamesByEmailWithHttpInfo($account_id, AccountsApi\ListRecipientNamesByEmailOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listRecipientNamesByEmail');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/recipient_names";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getEmail() !== null) {
            $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\RecipientNamesResponse',
                '/v2/accounts/{accountId}/recipient_names'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\RecipientNamesResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\RecipientNamesResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSettings
     *
     * Gets account settings information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSettingsInformation
     */
    public function listSettings($account_id)
    {
        list($response) = $this->listSettingsWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listSettingsWithHttpInfo
     *
     * Gets account settings information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSettingsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSettingsWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSettingsInformation',
                '/v2/accounts/{accountId}/settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSettingsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSettingsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSharedAccess
     *
     * Reserved: Gets the shared item status for one or more users.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSharedAccess
     */
    public function listSharedAccess($account_id, AccountsApi\ListSharedAccessOptions $options = null)
    {
        list($response) = $this->listSharedAccessWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listSharedAccessWithHttpInfo
     *
     * Reserved: Gets the shared item status for one or more users.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSharedAccess, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSharedAccessWithHttpInfo($account_id, AccountsApi\ListSharedAccessOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSharedAccess');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/shared_access";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getEnvelopesNotSharedUserStatus() !== null) {
            $queryParams['envelopes_not_shared_user_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getEnvelopesNotSharedUserStatus());
        }
        // query params
        if ($options->getFolderIds() !== null) {
            $queryParams['folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderIds());
        }
        // query params
        if ($options->getItemType() !== null) {
            $queryParams['item_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getItemType());
        }
        // query params
        if ($options->getSearchText() !== null) {
            $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
        }
        // query params
        if ($options->getShared() !== null) {
            $queryParams['shared'] = $this->apiClient->getSerializer()->toQueryValue($options->getShared());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        // query params
        if ($options->getUserIds() !== null) {
            $queryParams['user_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserIds());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSharedAccess',
                '/v2/accounts/{accountId}/shared_access'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSharedAccess', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSharedAccess', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listSignatureProviders
     *
     * Returns Account available signature providers for specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSignatureProviders
     */
    public function listSignatureProviders($account_id)
    {
        list($response) = $this->listSignatureProvidersWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listSignatureProvidersWithHttpInfo
     *
     * Returns Account available signature providers for specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSignatureProviders, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSignatureProvidersWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listSignatureProviders');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/signatureProviders";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSignatureProviders',
                '/v2/accounts/{accountId}/signatureProviders'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSignatureProviders', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSignatureProviders', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listUnsupportedFileTypes
     *
     * Gets a list of unsupported file types.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\FileTypeList
     */
    public function listUnsupportedFileTypes($account_id)
    {
        list($response) = $this->listUnsupportedFileTypesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listUnsupportedFileTypesWithHttpInfo
     *
     * Gets a list of unsupported file types.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\FileTypeList, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUnsupportedFileTypesWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listUnsupportedFileTypes');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/unsupported_file_types";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\FileTypeList',
                '/v2/accounts/{accountId}/unsupported_file_types'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\FileTypeList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\FileTypeList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateAccountTabSettings
     *
     * Modifies tab settings for specified account
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\TabAccountSettings $tab_account_settings  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TabAccountSettings
     */
    public function updateAccountTabSettings($account_id, $tab_account_settings = null)
    {
        list($response) = $this->updateAccountTabSettingsWithHttpInfo($account_id, $tab_account_settings);
        return $response;
    }

    /**
     * Operation updateAccountTabSettingsWithHttpInfo
     *
     * Modifies tab settings for specified account
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\TabAccountSettings $tab_account_settings  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TabAccountSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAccountTabSettingsWithHttpInfo($account_id, $tab_account_settings = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateAccountTabSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings/tabs";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($tab_account_settings)) {
            $_tempBody = $tab_account_settings;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TabAccountSettings',
                '/v2/accounts/{accountId}/settings/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TabAccountSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TabAccountSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrand
     *
     * Updates an existing brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Brand
     */
    public function updateBrand($account_id, $brand_id, $brand = null)
    {
        list($response) = $this->updateBrandWithHttpInfo($account_id, $brand_id, $brand);
        return $response;
    }

    /**
     * Operation updateBrandWithHttpInfo
     *
     * Updates an existing brand.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
     * @param \DocuSign\eSign\Model\Brand $brand  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Brand, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandWithHttpInfo($account_id, $brand_id, $brand = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrand');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrand');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brand)) {
            $_tempBody = $brand;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Brand',
                '/v2/accounts/{accountId}/brands/{brandId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Brand', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Brand', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrandLogoByType
     *
     * Put one branding logo.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $logo_type One of **Primary**, **Secondary** or **Email**.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function updateBrandLogoByType($account_id, $brand_id, $logo_type)
    {
        list($response) = $this->updateBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type);
        return $response;
    }

    /**
     * Operation updateBrandLogoByTypeWithHttpInfo
     *
     * Put one branding logo.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $logo_type One of **Primary**, **Secondary** or **Email**.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandLogoByTypeWithHttpInfo($account_id, $brand_id, $logo_type)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrandLogoByType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrandLogoByType');
        }
        // verify the required parameter 'logo_type' is set
        if ($logo_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $logo_type when calling updateBrandLogoByType');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // path params
        if ($logo_type !== null) {
            $resourcePath = str_replace(
                "{" . "logoType" . "}",
                $this->apiClient->getSerializer()->toPathValue($logo_type),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/brands/{brandId}/logos/{logoType}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrandResourcesByContentType
     *
     * Uploads a branding resource file.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $resource_content_type 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandResources
     */
    public function updateBrandResourcesByContentType($account_id, $brand_id, $resource_content_type)
    {
        list($response) = $this->updateBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type);
        return $response;
    }

    /**
     * Operation updateBrandResourcesByContentTypeWithHttpInfo
     *
     * Uploads a branding resource file.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $brand_id The unique identifier of a brand.
    * @param string $resource_content_type 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandResources, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandResourcesByContentTypeWithHttpInfo($account_id, $brand_id, $resource_content_type)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrandResourcesByContentType');
        }
        // verify the required parameter 'brand_id' is set
        if ($brand_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $brand_id when calling updateBrandResourcesByContentType');
        }
        // verify the required parameter 'resource_content_type' is set
        if ($resource_content_type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $resource_content_type when calling updateBrandResourcesByContentType');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($brand_id !== null) {
            $resourcePath = str_replace(
                "{" . "brandId" . "}",
                $this->apiClient->getSerializer()->toPathValue($brand_id),
                $resourcePath
            );
        }
        // path params
        if ($resource_content_type !== null) {
            $resourcePath = str_replace(
                "{" . "resourceContentType" . "}",
                $this->apiClient->getSerializer()->toPathValue($resource_content_type),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandResources',
                '/v2/accounts/{accountId}/brands/{brandId}/resources/{resourceContentType}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandResources', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandResources', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateENoteConfiguration
     *
     * Updates configuration information for the eNote eOriginal integration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ENoteConfiguration $e_note_configuration  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ENoteConfiguration
     */
    public function updateENoteConfiguration($account_id, $e_note_configuration = null)
    {
        list($response) = $this->updateENoteConfigurationWithHttpInfo($account_id, $e_note_configuration);
        return $response;
    }

    /**
     * Operation updateENoteConfigurationWithHttpInfo
     *
     * Updates configuration information for the eNote eOriginal integration.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ENoteConfiguration $e_note_configuration  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ENoteConfiguration, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateENoteConfigurationWithHttpInfo($account_id, $e_note_configuration = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateENoteConfiguration');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings/enote_configuration";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($e_note_configuration)) {
            $_tempBody = $e_note_configuration;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ENoteConfiguration',
                '/v2/accounts/{accountId}/settings/enote_configuration'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ENoteConfiguration', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ENoteConfiguration', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePermissionProfile
     *
     * Updates a permission profile within the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $permission_profile_id 
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PermissionProfile
     */
    public function updatePermissionProfile($account_id, $permission_profile_id, $permission_profile = null, AccountsApi\UpdatePermissionProfileOptions $options = null)
    {
        list($response) = $this->updatePermissionProfileWithHttpInfo($account_id, $permission_profile_id, $permission_profile, $options);
        return $response;
    }

    /**
     * Operation updatePermissionProfileWithHttpInfo
     *
     * Updates a permission profile within the specified account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $permission_profile_id 
     * @param \DocuSign\eSign\Model\PermissionProfile $permission_profile  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PermissionProfile, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePermissionProfileWithHttpInfo($account_id, $permission_profile_id, $permission_profile = null, AccountsApi\UpdatePermissionProfileOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updatePermissionProfile');
        }
        // verify the required parameter 'permission_profile_id' is set
        if ($permission_profile_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $permission_profile_id when calling updatePermissionProfile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getInclude() !== null) {
            $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($permission_profile_id !== null) {
            $resourcePath = str_replace(
                "{" . "permissionProfileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($permission_profile_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($permission_profile)) {
            $_tempBody = $permission_profile;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PermissionProfile',
                '/v2/accounts/{accountId}/permission_profiles/{permissionProfileId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PermissionProfile', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PermissionProfile', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSettings
     *
     * Updates the account settings for an account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSettingsInformation $account_settings_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function updateSettings($account_id, $account_settings_information = null)
    {
        list($response) = $this->updateSettingsWithHttpInfo($account_id, $account_settings_information);
        return $response;
    }

    /**
     * Operation updateSettingsWithHttpInfo
     *
     * Updates the account settings for an account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSettingsInformation $account_settings_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSettingsWithHttpInfo($account_id, $account_settings_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSettings');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/settings";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($account_settings_information)) {
            $_tempBody = $account_settings_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/settings'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateSharedAccess
     *
     * Reserved: Sets the shared access information for users.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSharedAccess $account_shared_access  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountSharedAccess
     */
    public function updateSharedAccess($account_id, $account_shared_access = null, AccountsApi\UpdateSharedAccessOptions $options = null)
    {
        list($response) = $this->updateSharedAccessWithHttpInfo($account_id, $account_shared_access, $options);
        return $response;
    }

    /**
     * Operation updateSharedAccessWithHttpInfo
     *
     * Reserved: Sets the shared access information for users.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\AccountSharedAccess $account_shared_access  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountSharedAccess, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSharedAccessWithHttpInfo($account_id, $account_shared_access = null, AccountsApi\UpdateSharedAccessOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateSharedAccess');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/shared_access";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getItemType() !== null) {
            $queryParams['item_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getItemType());
        }
        // query params
        if ($options->getUserIds() !== null) {
            $queryParams['user_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserIds());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($account_shared_access)) {
            $_tempBody = $account_shared_access;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountSharedAccess',
                '/v2/accounts/{accountId}/shared_access'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountSharedAccess', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountSharedAccess', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
