<?php
/**
 * BillingApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\BillingApi;

class GetPlanOptions
{
    /**
      * $include_credit_card_information When set to **true**, excludes credit card information from the response.
      * @var string
      */
    protected $include_credit_card_information;

    /**
     * Gets include_credit_card_information
     * @return string
     */
    public function getIncludeCreditCardInformation()
    {
        return $this->include_credit_card_information;
    }
  
    /**
     * Sets include_credit_card_information
     * @param string $include_credit_card_information When set to **true**, excludes credit card information from the response.
     * @return $this
     */
    public function setIncludeCreditCardInformation($include_credit_card_information)
    {
        $this->include_credit_card_information = $include_credit_card_information;
        return $this;
    }
    /**
      * $include_metadata When set to **true**, the `canUpgrade` and `renewalStatus` properities are included the response and an array of `supportedCountries` property is added to the `billingAddress` information.
      * @var string
      */
    protected $include_metadata;

    /**
     * Gets include_metadata
     * @return string
     */
    public function getIncludeMetadata()
    {
        return $this->include_metadata;
    }
  
    /**
     * Sets include_metadata
     * @param string $include_metadata When set to **true**, the `canUpgrade` and `renewalStatus` properities are included the response and an array of `supportedCountries` property is added to the `billingAddress` information.
     * @return $this
     */
    public function setIncludeMetadata($include_metadata)
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
    /**
      * $include_successor_plans When set to **true**, excludes successor information from the response.
      * @var string
      */
    protected $include_successor_plans;

    /**
     * Gets include_successor_plans
     * @return string
     */
    public function getIncludeSuccessorPlans()
    {
        return $this->include_successor_plans;
    }
  
    /**
     * Sets include_successor_plans
     * @param string $include_successor_plans When set to **true**, excludes successor information from the response.
     * @return $this
     */
    public function setIncludeSuccessorPlans($include_successor_plans)
    {
        $this->include_successor_plans = $include_successor_plans;
        return $this;
    }
}
class ListInvoicesOptions
{
    /**
      * $from_date Specifies the date/time of the earliest invoice in the account to retrieve.
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date Specifies the date/time of the earliest invoice in the account to retrieve.
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date Specifies the date/time of the latest invoice in the account to retrieve.
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date Specifies the date/time of the latest invoice in the account to retrieve.
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
}
class ListPaymentsOptions
{
    /**
      * $from_date Specifies the date/time of the earliest payment in the account to retrieve.
      * @var string
      */
    protected $from_date;

    /**
     * Gets from_date
     * @return string
     */
    public function getFromDate()
    {
        return $this->from_date;
    }
  
    /**
     * Sets from_date
     * @param string $from_date Specifies the date/time of the earliest payment in the account to retrieve.
     * @return $this
     */
    public function setFromDate($from_date)
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $to_date Specifies the date/time of the latest payment in the account to retrieve.
      * @var string
      */
    protected $to_date;

    /**
     * Gets to_date
     * @return string
     */
    public function getToDate()
    {
        return $this->to_date;
    }
  
    /**
     * Sets to_date
     * @param string $to_date Specifies the date/time of the latest payment in the account to retrieve.
     * @return $this
     */
    public function setToDate($to_date)
    {
        $this->to_date = $to_date;
        return $this;
    }
}
class UpdatePlanOptions
{
    /**
      * $preview_billing_plan When set to **true**, updates the account using a preview billing plan.
      * @var string
      */
    protected $preview_billing_plan;

    /**
     * Gets preview_billing_plan
     * @return string
     */
    public function getPreviewBillingPlan()
    {
        return $this->preview_billing_plan;
    }
  
    /**
     * Sets preview_billing_plan
     * @param string $preview_billing_plan When set to **true**, updates the account using a preview billing plan.
     * @return $this
     */
    public function setPreviewBillingPlan($preview_billing_plan)
    {
        $this->preview_billing_plan = $preview_billing_plan;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * BillingApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class BillingApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return BillingApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation getBillingPlan
     *
     * Get the billing plan details.
     *
    * @param string $billing_plan_id The ID of the billing plan being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPlanResponse
     */
    public function getBillingPlan($billing_plan_id)
    {
        list($response) = $this->getBillingPlanWithHttpInfo($billing_plan_id);
        return $response;
    }

    /**
     * Operation getBillingPlanWithHttpInfo
     *
     * Get the billing plan details.
     *
    * @param string $billing_plan_id The ID of the billing plan being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPlanResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBillingPlanWithHttpInfo($billing_plan_id)
    {
        // verify the required parameter 'billing_plan_id' is set
        if ($billing_plan_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $billing_plan_id when calling getBillingPlan');
        }
        // parse inputs
        $resourcePath = "/v2/billing_plans/{billingPlanId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($billing_plan_id !== null) {
            $resourcePath = str_replace(
                "{" . "billingPlanId" . "}",
                $this->apiClient->getSerializer()->toPathValue($billing_plan_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPlanResponse',
                '/v2/billing_plans/{billingPlanId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPlanResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPlanResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getInvoice
     *
     * Retrieves a billing invoice.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $invoice_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingInvoice
     */
    public function getInvoice($account_id, $invoice_id)
    {
        list($response) = $this->getInvoiceWithHttpInfo($account_id, $invoice_id);
        return $response;
    }

    /**
     * Operation getInvoiceWithHttpInfo
     *
     * Retrieves a billing invoice.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $invoice_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingInvoice, HTTP status code, HTTP response headers (array of strings)
     */
    public function getInvoiceWithHttpInfo($account_id, $invoice_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getInvoice');
        }
        // verify the required parameter 'invoice_id' is set
        if ($invoice_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $invoice_id when calling getInvoice');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_invoices/{invoiceId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($invoice_id !== null) {
            $resourcePath = str_replace(
                "{" . "invoiceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($invoice_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingInvoice',
                '/v2/accounts/{accountId}/billing_invoices/{invoiceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingInvoice', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingInvoice', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPayment
     *
     * Gets billing payment information for a specific payment.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $payment_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPaymentItem
     */
    public function getPayment($account_id, $payment_id)
    {
        list($response) = $this->getPaymentWithHttpInfo($account_id, $payment_id);
        return $response;
    }

    /**
     * Operation getPaymentWithHttpInfo
     *
     * Gets billing payment information for a specific payment.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $payment_id 
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPaymentItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaymentWithHttpInfo($account_id, $payment_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPayment');
        }
        // verify the required parameter 'payment_id' is set
        if ($payment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $payment_id when calling getPayment');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_payments/{paymentId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($payment_id !== null) {
            $resourcePath = str_replace(
                "{" . "paymentId" . "}",
                $this->apiClient->getSerializer()->toPathValue($payment_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPaymentItem',
                '/v2/accounts/{accountId}/billing_payments/{paymentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPaymentItem', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPaymentItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPlan
     *
     * Get Account Billing Plan
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\AccountBillingPlanResponse
     */
    public function getPlan($account_id, BillingApi\GetPlanOptions $options = null)
    {
        list($response) = $this->getPlanWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getPlanWithHttpInfo
     *
     * Get Account Billing Plan
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\AccountBillingPlanResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPlanWithHttpInfo($account_id, BillingApi\GetPlanOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPlan');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_plan";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIncludeCreditCardInformation() !== null) {
            $queryParams['include_credit_card_information'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeCreditCardInformation());
        }
        // query params
        if ($options->getIncludeMetadata() !== null) {
            $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
        }
        // query params
        if ($options->getIncludeSuccessorPlans() !== null) {
            $queryParams['include_successor_plans'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeSuccessorPlans());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\AccountBillingPlanResponse',
                '/v2/accounts/{accountId}/billing_plan'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\AccountBillingPlanResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\AccountBillingPlanResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listBillingPlans
     *
     * Gets the list of available billing plans.
     *
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPlansResponse
     */
    public function listBillingPlans()
    {
        list($response) = $this->listBillingPlansWithHttpInfo();
        return $response;
    }

    /**
     * Operation listBillingPlansWithHttpInfo
     *
     * Gets the list of available billing plans.
     *
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPlansResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBillingPlansWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/v2/billing_plans";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPlansResponse',
                '/v2/billing_plans'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPlansResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPlansResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listInvoices
     *
     * Get a List of Billing Invoices
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingInvoicesResponse
     */
    public function listInvoices($account_id, BillingApi\ListInvoicesOptions $options = null)
    {
        list($response) = $this->listInvoicesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listInvoicesWithHttpInfo
     *
     * Get a List of Billing Invoices
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingInvoicesResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listInvoicesWithHttpInfo($account_id, BillingApi\ListInvoicesOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listInvoices');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_invoices";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingInvoicesResponse',
                '/v2/accounts/{accountId}/billing_invoices'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingInvoicesResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingInvoicesResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listInvoicesPastDue
     *
     * Get a list of past due invoices.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingInvoicesSummary
     */
    public function listInvoicesPastDue($account_id)
    {
        list($response) = $this->listInvoicesPastDueWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listInvoicesPastDueWithHttpInfo
     *
     * Get a list of past due invoices.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingInvoicesSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function listInvoicesPastDueWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listInvoicesPastDue');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_invoices_past_due";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingInvoicesSummary',
                '/v2/accounts/{accountId}/billing_invoices_past_due'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingInvoicesSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingInvoicesSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listPayments
     *
     * Gets payment information for one or more payments.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPaymentsResponse
     */
    public function listPayments($account_id, BillingApi\ListPaymentsOptions $options = null)
    {
        list($response) = $this->listPaymentsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listPaymentsWithHttpInfo
     *
     * Gets payment information for one or more payments.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPaymentsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listPaymentsWithHttpInfo($account_id, BillingApi\ListPaymentsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listPayments');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_payments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getFromDate() !== null) {
            $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
        }
        // query params
        if ($options->getToDate() !== null) {
            $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPaymentsResponse',
                '/v2/accounts/{accountId}/billing_payments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPaymentsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPaymentsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation makePayment
     *
     * Posts a payment to a past due invoice.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPaymentRequest $billing_payment_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPaymentResponse
     */
    public function makePayment($account_id, $billing_payment_request = null)
    {
        list($response) = $this->makePaymentWithHttpInfo($account_id, $billing_payment_request);
        return $response;
    }

    /**
     * Operation makePaymentWithHttpInfo
     *
     * Posts a payment to a past due invoice.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPaymentRequest $billing_payment_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPaymentResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function makePaymentWithHttpInfo($account_id, $billing_payment_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling makePayment');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_payments";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($billing_payment_request)) {
            $_tempBody = $billing_payment_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPaymentResponse',
                '/v2/accounts/{accountId}/billing_payments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPaymentResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPaymentResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation purchaseEnvelopes
     *
     * Reserverd: Purchase additional envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PurchasedEnvelopesInformation $purchased_envelopes_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function purchaseEnvelopes($account_id, $purchased_envelopes_information = null)
    {
        list($response) = $this->purchaseEnvelopesWithHttpInfo($account_id, $purchased_envelopes_information);
        return $response;
    }

    /**
     * Operation purchaseEnvelopesWithHttpInfo
     *
     * Reserverd: Purchase additional envelopes.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\PurchasedEnvelopesInformation $purchased_envelopes_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function purchaseEnvelopesWithHttpInfo($account_id, $purchased_envelopes_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling purchaseEnvelopes');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_plan/purchased_envelopes";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($purchased_envelopes_information)) {
            $_tempBody = $purchased_envelopes_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/billing_plan/purchased_envelopes'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updatePlan
     *
     * Updates the account billing plan.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPlanInformation $billing_plan_information  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BillingPlanUpdateResponse
     */
    public function updatePlan($account_id, $billing_plan_information = null, BillingApi\UpdatePlanOptions $options = null)
    {
        list($response) = $this->updatePlanWithHttpInfo($account_id, $billing_plan_information, $options);
        return $response;
    }

    /**
     * Operation updatePlanWithHttpInfo
     *
     * Updates the account billing plan.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\BillingPlanInformation $billing_plan_information  (optional)
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BillingPlanUpdateResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePlanWithHttpInfo($account_id, $billing_plan_information = null, BillingApi\UpdatePlanOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updatePlan');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/billing_plan";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getPreviewBillingPlan() !== null) {
            $queryParams['preview_billing_plan'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreviewBillingPlan());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($billing_plan_information)) {
            $_tempBody = $billing_plan_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BillingPlanUpdateResponse',
                '/v2/accounts/{accountId}/billing_plan'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BillingPlanUpdateResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BillingPlanUpdateResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
