<?php
/**
 * GroupsApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\GroupsApi;

class ListGroupUsersOptions
{
    /**
      * $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $start_position Starting value for the list.
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position Starting value for the list.
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
}
class ListGroupsOptions
{
    /**
      * $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count Number of records to return. The number must be greater than 1 and less than or equal to 100.
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $group_name Filters the groups returned by the group name or a sub-string of group name.
      * @var string
      */
    protected $group_name;

    /**
     * Gets group_name
     * @return string
     */
    public function getGroupName()
    {
        return $this->group_name;
    }
  
    /**
     * Sets group_name
     * @param string $group_name Filters the groups returned by the group name or a sub-string of group name.
     * @return $this
     */
    public function setGroupName($group_name)
    {
        $this->group_name = $group_name;
        return $this;
    }
    /**
      * $group_type 
      * @var string
      */
    protected $group_type;

    /**
     * Gets group_type
     * @return string
     */
    public function getGroupType()
    {
        return $this->group_type;
    }
  
    /**
     * Sets group_type
     * @param string $group_type 
     * @return $this
     */
    public function setGroupType($group_type)
    {
        $this->group_type = $group_type;
        return $this;
    }
    /**
      * $search_text 
      * @var string
      */
    protected $search_text;

    /**
     * Gets search_text
     * @return string
     */
    public function getSearchText()
    {
        return $this->search_text;
    }
  
    /**
     * Sets search_text
     * @param string $search_text 
     * @return $this
     */
    public function setSearchText($search_text)
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position Starting value for the list.
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position Starting value for the list.
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * GroupsApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GroupsApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return GroupsApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createGroups
     *
     * Creates one or more groups for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function createGroups($account_id, $group_information = null)
    {
        list($response) = $this->createGroupsWithHttpInfo($account_id, $group_information);
        return $response;
    }

    /**
     * Operation createGroupsWithHttpInfo
     *
     * Creates one or more groups for the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createGroupsWithHttpInfo($account_id, $group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createGroups');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteBrands
     *
     * Deletes brand information from the requested group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function deleteBrands($account_id, $group_id, $brands_request = null)
    {
        list($response) = $this->deleteBrandsWithHttpInfo($account_id, $group_id, $brands_request);
        return $response;
    }

    /**
     * Operation deleteBrandsWithHttpInfo
     *
     * Deletes brand information from the requested group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBrandsWithHttpInfo($account_id, $group_id, $brands_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteBrands');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling deleteBrands');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups/{groupId}/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                "{" . "groupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brands_request)) {
            $_tempBody = $brands_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2/accounts/{accountId}/groups/{groupId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteGroupUsers
     *
     * Deletes one or more users from a gro
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function deleteGroupUsers($account_id, $group_id, $user_info_list = null)
    {
        list($response) = $this->deleteGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list);
        return $response;
    }

    /**
     * Operation deleteGroupUsersWithHttpInfo
     *
     * Deletes one or more users from a gro
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteGroupUsers');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling deleteGroupUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups/{groupId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                "{" . "groupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($user_info_list)) {
            $_tempBody = $user_info_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2/accounts/{accountId}/groups/{groupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteGroups
     *
     * Deletes an existing user group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function deleteGroups($account_id, $group_information = null)
    {
        list($response) = $this->deleteGroupsWithHttpInfo($account_id, $group_information);
        return $response;
    }

    /**
     * Operation deleteGroupsWithHttpInfo
     *
     * Deletes an existing user group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupsWithHttpInfo($account_id, $group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteGroups');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getBrands
     *
     * Gets group brand ID Information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function getBrands($account_id, $group_id)
    {
        list($response) = $this->getBrandsWithHttpInfo($account_id, $group_id);
        return $response;
    }

    /**
     * Operation getBrandsWithHttpInfo
     *
     * Gets group brand ID Information.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBrandsWithHttpInfo($account_id, $group_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getBrands');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling getBrands');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups/{groupId}/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                "{" . "groupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2/accounts/{accountId}/groups/{groupId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listGroupUsers
     *
     * Gets a list of users in a group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function listGroupUsers($account_id, $group_id, GroupsApi\ListGroupUsersOptions $options = null)
    {
        list($response) = $this->listGroupUsersWithHttpInfo($account_id, $group_id, $options);
        return $response;
    }

    /**
     * Operation listGroupUsersWithHttpInfo
     *
     * Gets a list of users in a group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGroupUsersWithHttpInfo($account_id, $group_id, GroupsApi\ListGroupUsersOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listGroupUsers');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling listGroupUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups/{groupId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                "{" . "groupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2/accounts/{accountId}/groups/{groupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listGroups
     *
     * Gets information about groups associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function listGroups($account_id, GroupsApi\ListGroupsOptions $options = null)
    {
        list($response) = $this->listGroupsWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listGroupsWithHttpInfo
     *
     * Gets information about groups associated with the account.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGroupsWithHttpInfo($account_id, GroupsApi\ListGroupsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listGroups');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getGroupName() !== null) {
            $queryParams['group_name'] = $this->apiClient->getSerializer()->toQueryValue($options->getGroupName());
        }
        // query params
        if ($options->getGroupType() !== null) {
            $queryParams['group_type'] = $this->apiClient->getSerializer()->toQueryValue($options->getGroupType());
        }
        // query params
        if ($options->getSearchText() !== null) {
            $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateBrands
     *
     * Adds group brand ID information to a group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\BrandsResponse
     */
    public function updateBrands($account_id, $group_id, $brands_request = null)
    {
        list($response) = $this->updateBrandsWithHttpInfo($account_id, $group_id, $brands_request);
        return $response;
    }

    /**
     * Operation updateBrandsWithHttpInfo
     *
     * Adds group brand ID information to a group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\BrandsRequest $brands_request  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\BrandsResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateBrandsWithHttpInfo($account_id, $group_id, $brands_request = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateBrands');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling updateBrands');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups/{groupId}/brands";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                "{" . "groupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($brands_request)) {
            $_tempBody = $brands_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\BrandsResponse',
                '/v2/accounts/{accountId}/groups/{groupId}/brands'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\BrandsResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\BrandsResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateGroupUsers
     *
     * Adds one or more users to an existing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UsersResponse
     */
    public function updateGroupUsers($account_id, $group_id, $user_info_list = null)
    {
        list($response) = $this->updateGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list);
        return $response;
    }

    /**
     * Operation updateGroupUsersWithHttpInfo
     *
     * Adds one or more users to an existing group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $group_id The ID of the group being accessed.
     * @param \DocuSign\eSign\Model\UserInfoList $user_info_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UsersResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupUsersWithHttpInfo($account_id, $group_id, $user_info_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateGroupUsers');
        }
        // verify the required parameter 'group_id' is set
        if ($group_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $group_id when calling updateGroupUsers');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups/{groupId}/users";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                "{" . "groupId" . "}",
                $this->apiClient->getSerializer()->toPathValue($group_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($user_info_list)) {
            $_tempBody = $user_info_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UsersResponse',
                '/v2/accounts/{accountId}/groups/{groupId}/users'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UsersResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UsersResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateGroups
     *
     * Updates the group information for a group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\GroupInformation
     */
    public function updateGroups($account_id, $group_information = null)
    {
        list($response) = $this->updateGroupsWithHttpInfo($account_id, $group_information);
        return $response;
    }

    /**
     * Operation updateGroupsWithHttpInfo
     *
     * Updates the group information for a group.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\GroupInformation $group_information  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\GroupInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupsWithHttpInfo($account_id, $group_information = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateGroups');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/groups";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($group_information)) {
            $_tempBody = $group_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\GroupInformation',
                '/v2/accounts/{accountId}/groups'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\GroupInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\GroupInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
