<?php
/**
 * WorkspacesApi
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\WorkspacesApi;

class GetWorkspaceFileOptions
{
    /**
      * $is_download When set to **true**, the Content-Disposition header is set in the response. The value of the header provides the filename of the file. Default is **false**.
      * @var string
      */
    protected $is_download;

    /**
     * Gets is_download
     * @return string
     */
    public function getIsDownload()
    {
        return $this->is_download;
    }
  
    /**
     * Sets is_download
     * @param string $is_download When set to **true**, the Content-Disposition header is set in the response. The value of the header provides the filename of the file. Default is **false**.
     * @return $this
     */
    public function setIsDownload($is_download)
    {
        $this->is_download = $is_download;
        return $this;
    }
    /**
      * $pdf_version When set to **true** the file returned as a PDF.
      * @var string
      */
    protected $pdf_version;

    /**
     * Gets pdf_version
     * @return string
     */
    public function getPdfVersion()
    {
        return $this->pdf_version;
    }
  
    /**
     * Sets pdf_version
     * @param string $pdf_version When set to **true** the file returned as a PDF.
     * @return $this
     */
    public function setPdfVersion($pdf_version)
    {
        $this->pdf_version = $pdf_version;
        return $this;
    }
}
class ListWorkspaceFilePagesOptions
{
    /**
      * $count The maximum number of results to be returned by this request.
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count The maximum number of results to be returned by this request.
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $dpi Number of dots per inch for the resulting image. The default if not used is 94. The range is 1-310.
      * @var string
      */
    protected $dpi;

    /**
     * Gets dpi
     * @return string
     */
    public function getDpi()
    {
        return $this->dpi;
    }
  
    /**
     * Sets dpi
     * @param string $dpi Number of dots per inch for the resulting image. The default if not used is 94. The range is 1-310.
     * @return $this
     */
    public function setDpi($dpi)
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height Sets the maximum height (in pixels) of the returned image.
      * @var string
      */
    protected $max_height;

    /**
     * Gets max_height
     * @return string
     */
    public function getMaxHeight()
    {
        return $this->max_height;
    }
  
    /**
     * Sets max_height
     * @param string $max_height Sets the maximum height (in pixels) of the returned image.
     * @return $this
     */
    public function setMaxHeight($max_height)
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width Sets the maximum width (in pixels) of the returned image.
      * @var string
      */
    protected $max_width;

    /**
     * Gets max_width
     * @return string
     */
    public function getMaxWidth()
    {
        return $this->max_width;
    }
  
    /**
     * Sets max_width
     * @param string $max_width Sets the maximum width (in pixels) of the returned image.
     * @return $this
     */
    public function setMaxWidth($max_width)
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $start_position The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position The position within the total result set from which to start returning values. The value **thumbnail** may be used to return the page image.
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
}
class ListWorkspaceFolderItemsOptions
{
    /**
      * $count The maximum number of results to be returned by this request.
      * @var string
      */
    protected $count;

    /**
     * Gets count
     * @return string
     */
    public function getCount()
    {
        return $this->count;
    }
  
    /**
     * Sets count
     * @param string $count The maximum number of results to be returned by this request.
     * @return $this
     */
    public function setCount($count)
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $include_files When set to **true**, file information is returned in the response along with folder information. The default is **false**.
      * @var string
      */
    protected $include_files;

    /**
     * Gets include_files
     * @return string
     */
    public function getIncludeFiles()
    {
        return $this->include_files;
    }
  
    /**
     * Sets include_files
     * @param string $include_files When set to **true**, file information is returned in the response along with folder information. The default is **false**.
     * @return $this
     */
    public function setIncludeFiles($include_files)
    {
        $this->include_files = $include_files;
        return $this;
    }
    /**
      * $include_sub_folders When set to **true**, information about the sub-folders of the current folder is returned. The default is **false**.
      * @var string
      */
    protected $include_sub_folders;

    /**
     * Gets include_sub_folders
     * @return string
     */
    public function getIncludeSubFolders()
    {
        return $this->include_sub_folders;
    }
  
    /**
     * Sets include_sub_folders
     * @param string $include_sub_folders When set to **true**, information about the sub-folders of the current folder is returned. The default is **false**.
     * @return $this
     */
    public function setIncludeSubFolders($include_sub_folders)
    {
        $this->include_sub_folders = $include_sub_folders;
        return $this;
    }
    /**
      * $include_thumbnails When set to **true**, thumbnails are returned as part of the response.  The default is **false**.
      * @var string
      */
    protected $include_thumbnails;

    /**
     * Gets include_thumbnails
     * @return string
     */
    public function getIncludeThumbnails()
    {
        return $this->include_thumbnails;
    }
  
    /**
     * Sets include_thumbnails
     * @param string $include_thumbnails When set to **true**, thumbnails are returned as part of the response.  The default is **false**.
     * @return $this
     */
    public function setIncludeThumbnails($include_thumbnails)
    {
        $this->include_thumbnails = $include_thumbnails;
        return $this;
    }
    /**
      * $include_user_detail Set to **true** to return extended details about the user. The default is **false**.
      * @var string
      */
    protected $include_user_detail;

    /**
     * Gets include_user_detail
     * @return string
     */
    public function getIncludeUserDetail()
    {
        return $this->include_user_detail;
    }
  
    /**
     * Sets include_user_detail
     * @param string $include_user_detail Set to **true** to return extended details about the user. The default is **false**.
     * @return $this
     */
    public function setIncludeUserDetail($include_user_detail)
    {
        $this->include_user_detail = $include_user_detail;
        return $this;
    }
    /**
      * $start_position The position within the total result set from which to start returning values.
      * @var string
      */
    protected $start_position;

    /**
     * Gets start_position
     * @return string
     */
    public function getStartPosition()
    {
        return $this->start_position;
    }
  
    /**
     * Sets start_position
     * @param string $start_position The position within the total result set from which to start returning values.
     * @return $this
     */
    public function setStartPosition($start_position)
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $workspace_user_id If set, then the results are filtered to those associated with the specified userId.
      * @var string
      */
    protected $workspace_user_id;

    /**
     * Gets workspace_user_id
     * @return string
     */
    public function getWorkspaceUserId()
    {
        return $this->workspace_user_id;
    }
  
    /**
     * Sets workspace_user_id
     * @param string $workspace_user_id If set, then the results are filtered to those associated with the specified userId.
     * @return $this
     */
    public function setWorkspaceUserId($workspace_user_id)
    {
        $this->workspace_user_id = $workspace_user_id;
        return $this;
    }
}


namespace DocuSign\eSign\Api;

use \DocuSign\eSign\ApiClient;
use \DocuSign\eSign\ApiException;
use \DocuSign\eSign\Configuration;
use \DocuSign\eSign\ObjectSerializer;

/**
 * WorkspacesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class WorkspacesApi
{
    /**
     * API Client
     *
     * @var \DocuSign\eSign\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \DocuSign\eSign\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\DocuSign\eSign\ApiClient $apiClient = null)
    {
        if ($apiClient === null) {
            $apiClient = new ApiClient();
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \DocuSign\eSign\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \DocuSign\eSign\ApiClient $apiClient set the API client
     *
     * @return WorkspacesApi
     */
    public function setApiClient(\DocuSign\eSign\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation createWorkspace
     *
     * Create a Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function createWorkspace($account_id, $workspace = null)
    {
        list($response) = $this->createWorkspaceWithHttpInfo($account_id, $workspace);
        return $response;
    }

    /**
     * Operation createWorkspaceWithHttpInfo
     *
     * Create a Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWorkspaceWithHttpInfo($account_id, $workspace = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($workspace)) {
            $_tempBody = $workspace;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2/accounts/{accountId}/workspaces'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createWorkspaceFile
     *
     * Creates a workspace file.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceItem
     */
    public function createWorkspaceFile($account_id, $folder_id, $workspace_id)
    {
        list($response) = $this->createWorkspaceFileWithHttpInfo($account_id, $folder_id, $workspace_id);
        return $response;
    }

    /**
     * Operation createWorkspaceFileWithHttpInfo
     *
     * Creates a workspace file.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createWorkspaceFileWithHttpInfo($account_id, $folder_id, $workspace_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createWorkspaceFile');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling createWorkspaceFile');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling createWorkspaceFile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                "{" . "folderId" . "}",
                $this->apiClient->getSerializer()->toPathValue($folder_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceItem',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceItem', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkspace
     *
     * Delete Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function deleteWorkspace($account_id, $workspace_id)
    {
        list($response) = $this->deleteWorkspaceWithHttpInfo($account_id, $workspace_id);
        return $response;
    }

    /**
     * Operation deleteWorkspaceWithHttpInfo
     *
     * Delete Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWorkspaceWithHttpInfo($account_id, $workspace_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteWorkspace');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling deleteWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteWorkspaceFolderItems
     *
     * Deletes workspace one or more specific files/folders from the given folder or root.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\WorkspaceItemList $workspace_item_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function deleteWorkspaceFolderItems($account_id, $folder_id, $workspace_id, $workspace_item_list = null)
    {
        list($response) = $this->deleteWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, $workspace_item_list);
        return $response;
    }

    /**
     * Operation deleteWorkspaceFolderItemsWithHttpInfo
     *
     * Deletes workspace one or more specific files/folders from the given folder or root.
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\WorkspaceItemList $workspace_item_list  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, $workspace_item_list = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteWorkspaceFolderItems');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling deleteWorkspaceFolderItems');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling deleteWorkspaceFolderItems');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                "{" . "folderId" . "}",
                $this->apiClient->getSerializer()->toPathValue($folder_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($workspace_item_list)) {
            $_tempBody = $workspace_item_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkspace
     *
     * Get Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function getWorkspace($account_id, $workspace_id)
    {
        list($response) = $this->getWorkspaceWithHttpInfo($account_id, $workspace_id);
        return $response;
    }

    /**
     * Operation getWorkspaceWithHttpInfo
     *
     * Get Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWorkspaceWithHttpInfo($account_id, $workspace_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getWorkspace');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling getWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getWorkspaceFile
     *
     * Get Workspace File
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $file_id Specifies the room file ID GUID.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return void
     */
    public function getWorkspaceFile($account_id, $file_id, $folder_id, $workspace_id, WorkspacesApi\GetWorkspaceFileOptions $options = null)
    {
        list($response) = $this->getWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, $options);
        return $response;
    }

    /**
     * Operation getWorkspaceFileWithHttpInfo
     *
     * Get Workspace File
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $file_id Specifies the room file ID GUID.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, WorkspacesApi\GetWorkspaceFileOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getWorkspaceFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling getWorkspaceFile');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling getWorkspaceFile');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling getWorkspaceFile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getIsDownload() !== null) {
            $queryParams['is_download'] = $this->apiClient->getSerializer()->toQueryValue($options->getIsDownload());
        }
        // query params
        if ($options->getPdfVersion() !== null) {
            $queryParams['pdf_version'] = $this->apiClient->getSerializer()->toQueryValue($options->getPdfVersion());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "fileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                "{" . "folderId" . "}",
                $this->apiClient->getSerializer()->toPathValue($folder_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listWorkspaceFilePages
     *
     * List File Pages
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $file_id Specifies the room file ID GUID.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PageImages
     */
    public function listWorkspaceFilePages($account_id, $file_id, $folder_id, $workspace_id, WorkspacesApi\ListWorkspaceFilePagesOptions $options = null)
    {
        list($response) = $this->listWorkspaceFilePagesWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, $options);
        return $response;
    }

    /**
     * Operation listWorkspaceFilePagesWithHttpInfo
     *
     * List File Pages
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $file_id Specifies the room file ID GUID.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PageImages, HTTP status code, HTTP response headers (array of strings)
     */
    public function listWorkspaceFilePagesWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id, WorkspacesApi\ListWorkspaceFilePagesOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listWorkspaceFilePages');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling listWorkspaceFilePages');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling listWorkspaceFilePages');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling listWorkspaceFilePages');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getDpi() !== null) {
            $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
        }
        // query params
        if ($options->getMaxHeight() !== null) {
            $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
        }
        // query params
        if ($options->getMaxWidth() !== null) {
            $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "fileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                "{" . "folderId" . "}",
                $this->apiClient->getSerializer()->toPathValue($folder_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PageImages',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}/pages'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PageImages', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PageImages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listWorkspaceFolderItems
     *
     * List Workspace Folder Contents
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceFolderContents
     */
    public function listWorkspaceFolderItems($account_id, $folder_id, $workspace_id, WorkspacesApi\ListWorkspaceFolderItemsOptions $options = null)
    {
        list($response) = $this->listWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, $options);
        return $response;
    }

    /**
     * Operation listWorkspaceFolderItemsWithHttpInfo
     *
     * List Workspace Folder Contents
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param  $options Options for modifying the behavior of the function. (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceFolderContents, HTTP status code, HTTP response headers (array of strings)
     */
    public function listWorkspaceFolderItemsWithHttpInfo($account_id, $folder_id, $workspace_id, WorkspacesApi\ListWorkspaceFolderItemsOptions $options = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listWorkspaceFolderItems');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling listWorkspaceFolderItems');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling listWorkspaceFolderItems');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
        // query params
        // query params
        if ($options->getCount() !== null) {
            $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
        }
        // query params
        if ($options->getIncludeFiles() !== null) {
            $queryParams['include_files'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeFiles());
        }
        // query params
        if ($options->getIncludeSubFolders() !== null) {
            $queryParams['include_sub_folders'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeSubFolders());
        }
        // query params
        if ($options->getIncludeThumbnails() !== null) {
            $queryParams['include_thumbnails'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeThumbnails());
        }
        // query params
        if ($options->getIncludeUserDetail() !== null) {
            $queryParams['include_user_detail'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeUserDetail());
        }
        // query params
        if ($options->getStartPosition() !== null) {
            $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
        }
        // query params
        if ($options->getWorkspaceUserId() !== null) {
            $queryParams['workspace_user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getWorkspaceUserId());
        }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                "{" . "folderId" . "}",
                $this->apiClient->getSerializer()->toPathValue($folder_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceFolderContents',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceFolderContents', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceFolderContents', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listWorkspaces
     *
     * List Workspaces
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceList
     */
    public function listWorkspaces($account_id)
    {
        list($response) = $this->listWorkspacesWithHttpInfo($account_id);
        return $response;
    }

    /**
     * Operation listWorkspacesWithHttpInfo
     *
     * List Workspaces
     *
    * @param string $account_id The external account number (int) or account ID Guid.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceList, HTTP status code, HTTP response headers (array of strings)
     */
    public function listWorkspacesWithHttpInfo($account_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listWorkspaces');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceList',
                '/v2/accounts/{accountId}/workspaces'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateWorkspace
     *
     * Update Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workspace
     */
    public function updateWorkspace($account_id, $workspace_id, $workspace = null)
    {
        list($response) = $this->updateWorkspaceWithHttpInfo($account_id, $workspace_id, $workspace);
        return $response;
    }

    /**
     * Operation updateWorkspaceWithHttpInfo
     *
     * Update Workspace
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @param \DocuSign\eSign\Model\Workspace $workspace  (optional)
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workspace, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWorkspaceWithHttpInfo($account_id, $workspace_id, $workspace = null)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateWorkspace');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling updateWorkspace');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($workspace)) {
            $_tempBody = $workspace;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workspace',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workspace', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workspace', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateWorkspaceFile
     *
     * Update Workspace File Metadata
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $file_id Specifies the room file ID GUID.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkspaceItem
     */
    public function updateWorkspaceFile($account_id, $file_id, $folder_id, $workspace_id)
    {
        list($response) = $this->updateWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id);
        return $response;
    }

    /**
     * Operation updateWorkspaceFileWithHttpInfo
     *
     * Update Workspace File Metadata
     *
    * @param string $account_id The external account number (int) or account ID Guid.
    * @param string $file_id Specifies the room file ID GUID.
    * @param string $folder_id The ID of the folder being accessed.
    * @param string $workspace_id Specifies the workspace ID GUID.
     * @throws \DocuSign\eSign\ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkspaceItem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWorkspaceFileWithHttpInfo($account_id, $file_id, $folder_id, $workspace_id)
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateWorkspaceFile');
        }
        // verify the required parameter 'file_id' is set
        if ($file_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $file_id when calling updateWorkspaceFile');
        }
        // verify the required parameter 'folder_id' is set
        if ($folder_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $folder_id when calling updateWorkspaceFile');
        }
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workspace_id when calling updateWorkspaceFile');
        }
        // parse inputs
        $resourcePath = "/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}";
        $httpBody = '';
        $queryParams = [];
        $headerParams = [];
        $formParams = [];
        $_header_accept = $this->apiClient->selectHeaderAccept(['application/json']);
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = str_replace(
                "{" . "accountId" . "}",
                $this->apiClient->getSerializer()->toPathValue($account_id),
                $resourcePath
            );
        }
        // path params
        if ($file_id !== null) {
            $resourcePath = str_replace(
                "{" . "fileId" . "}",
                $this->apiClient->getSerializer()->toPathValue($file_id),
                $resourcePath
            );
        }
        // path params
        if ($folder_id !== null) {
            $resourcePath = str_replace(
                "{" . "folderId" . "}",
                $this->apiClient->getSerializer()->toPathValue($folder_id),
                $resourcePath
            );
        }
        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                "{" . "workspaceId" . "}",
                $this->apiClient->getSerializer()->toPathValue($workspace_id),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkspaceItem',
                '/v2/accounts/{accountId}/workspaces/{workspaceId}/folders/{folderId}/files/{fileId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkspaceItem', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkspaceItem', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
