<?php
/**
 * BillingPlan
 *
 * PHP version 5
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swaagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;

/**
 * BillingPlan Class Doc Comment
 *
 * @category    Class
 * @description Contains information about a billing plan.
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BillingPlan implements ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'billingPlan';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = [
        'app_store_products' => '\DocuSign\eSign\Model\AppStoreProduct[]',
        'currency_plan_prices' => '\DocuSign\eSign\Model\CurrencyPlanPrice[]',
        'enable_support' => 'string',
        'included_seats' => 'string',
        'other_discount_percent' => 'string',
        'payment_cycle' => 'string',
        'payment_method' => 'string',
        'per_seat_price' => 'string',
        'plan_classification' => 'string',
        'plan_feature_sets' => '\DocuSign\eSign\Model\FeatureSet[]',
        'plan_id' => 'string',
        'plan_name' => 'string',
        'seat_discounts' => '\DocuSign\eSign\Model\SeatDiscount[]',
        'support_incident_fee' => 'string',
        'support_plan_fee' => 'string'
    ];

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = [
        'app_store_products' => 'appStoreProducts',
        'currency_plan_prices' => 'currencyPlanPrices',
        'enable_support' => 'enableSupport',
        'included_seats' => 'includedSeats',
        'other_discount_percent' => 'otherDiscountPercent',
        'payment_cycle' => 'paymentCycle',
        'payment_method' => 'paymentMethod',
        'per_seat_price' => 'perSeatPrice',
        'plan_classification' => 'planClassification',
        'plan_feature_sets' => 'planFeatureSets',
        'plan_id' => 'planId',
        'plan_name' => 'planName',
        'seat_discounts' => 'seatDiscounts',
        'support_incident_fee' => 'supportIncidentFee',
        'support_plan_fee' => 'supportPlanFee'
    ];


    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = [
        'app_store_products' => 'setAppStoreProducts',
        'currency_plan_prices' => 'setCurrencyPlanPrices',
        'enable_support' => 'setEnableSupport',
        'included_seats' => 'setIncludedSeats',
        'other_discount_percent' => 'setOtherDiscountPercent',
        'payment_cycle' => 'setPaymentCycle',
        'payment_method' => 'setPaymentMethod',
        'per_seat_price' => 'setPerSeatPrice',
        'plan_classification' => 'setPlanClassification',
        'plan_feature_sets' => 'setPlanFeatureSets',
        'plan_id' => 'setPlanId',
        'plan_name' => 'setPlanName',
        'seat_discounts' => 'setSeatDiscounts',
        'support_incident_fee' => 'setSupportIncidentFee',
        'support_plan_fee' => 'setSupportPlanFee'
    ];


    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = [
        'app_store_products' => 'getAppStoreProducts',
        'currency_plan_prices' => 'getCurrencyPlanPrices',
        'enable_support' => 'getEnableSupport',
        'included_seats' => 'getIncludedSeats',
        'other_discount_percent' => 'getOtherDiscountPercent',
        'payment_cycle' => 'getPaymentCycle',
        'payment_method' => 'getPaymentMethod',
        'per_seat_price' => 'getPerSeatPrice',
        'plan_classification' => 'getPlanClassification',
        'plan_feature_sets' => 'getPlanFeatureSets',
        'plan_id' => 'getPlanId',
        'plan_name' => 'getPlanName',
        'seat_discounts' => 'getSeatDiscounts',
        'support_incident_fee' => 'getSupportIncidentFee',
        'support_plan_fee' => 'getSupportPlanFee'
    ];

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    public static function setters()
    {
        return self::$setters;
    }

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     * @param mixed[] $data Associated array of property values initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['app_store_products'] = isset($data['app_store_products']) ? $data['app_store_products'] : null;
        $this->container['currency_plan_prices'] = isset($data['currency_plan_prices']) ? $data['currency_plan_prices'] : null;
        $this->container['enable_support'] = isset($data['enable_support']) ? $data['enable_support'] : null;
        $this->container['included_seats'] = isset($data['included_seats']) ? $data['included_seats'] : null;
        $this->container['other_discount_percent'] = isset($data['other_discount_percent']) ? $data['other_discount_percent'] : null;
        $this->container['payment_cycle'] = isset($data['payment_cycle']) ? $data['payment_cycle'] : null;
        $this->container['payment_method'] = isset($data['payment_method']) ? $data['payment_method'] : null;
        $this->container['per_seat_price'] = isset($data['per_seat_price']) ? $data['per_seat_price'] : null;
        $this->container['plan_classification'] = isset($data['plan_classification']) ? $data['plan_classification'] : null;
        $this->container['plan_feature_sets'] = isset($data['plan_feature_sets']) ? $data['plan_feature_sets'] : null;
        $this->container['plan_id'] = isset($data['plan_id']) ? $data['plan_id'] : null;
        $this->container['plan_name'] = isset($data['plan_name']) ? $data['plan_name'] : null;
        $this->container['seat_discounts'] = isset($data['seat_discounts']) ? $data['seat_discounts'] : null;
        $this->container['support_incident_fee'] = isset($data['support_incident_fee']) ? $data['support_incident_fee'] : null;
        $this->container['support_plan_fee'] = isset($data['support_plan_fee']) ? $data['support_plan_fee'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = [];
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets app_store_products
     * @return \DocuSign\eSign\Model\AppStoreProduct[]
     */
    public function getAppStoreProducts()
    {
        return $this->container['app_store_products'];
    }

    /**
     * Sets app_store_products
     * @param \DocuSign\eSign\Model\AppStoreProduct[] $app_store_products Reserved: TBD
     * @return $this
     */
    public function setAppStoreProducts($app_store_products)
    {
        $this->container['app_store_products'] = $app_store_products;

        return $this;
    }

    /**
     * Gets currency_plan_prices
     * @return \DocuSign\eSign\Model\CurrencyPlanPrice[]
     */
    public function getCurrencyPlanPrices()
    {
        return $this->container['currency_plan_prices'];
    }

    /**
     * Sets currency_plan_prices
     * @param \DocuSign\eSign\Model\CurrencyPlanPrice[] $currency_plan_prices Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, and seatFee that are configured for this plan feature set.
     * @return $this
     */
    public function setCurrencyPlanPrices($currency_plan_prices)
    {
        $this->container['currency_plan_prices'] = $currency_plan_prices;

        return $this;
    }

    /**
     * Gets enable_support
     * @return string
     */
    public function getEnableSupport()
    {
        return $this->container['enable_support'];
    }

    /**
     * Sets enable_support
     * @param string $enable_support When set to **true**, then customer support is provided as part of the account plan.
     * @return $this
     */
    public function setEnableSupport($enable_support)
    {
        $this->container['enable_support'] = $enable_support;

        return $this;
    }

    /**
     * Gets included_seats
     * @return string
     */
    public function getIncludedSeats()
    {
        return $this->container['included_seats'];
    }

    /**
     * Sets included_seats
     * @param string $included_seats The number of seats (users) included.
     * @return $this
     */
    public function setIncludedSeats($included_seats)
    {
        $this->container['included_seats'] = $included_seats;

        return $this;
    }

    /**
     * Gets other_discount_percent
     * @return string
     */
    public function getOtherDiscountPercent()
    {
        return $this->container['other_discount_percent'];
    }

    /**
     * Sets other_discount_percent
     * @param string $other_discount_percent 
     * @return $this
     */
    public function setOtherDiscountPercent($other_discount_percent)
    {
        $this->container['other_discount_percent'] = $other_discount_percent;

        return $this;
    }

    /**
     * Gets payment_cycle
     * @return string
     */
    public function getPaymentCycle()
    {
        return $this->container['payment_cycle'];
    }

    /**
     * Sets payment_cycle
     * @param string $payment_cycle The payment cycle associated with the plan. The possible values are: Monthly or Annually.
     * @return $this
     */
    public function setPaymentCycle($payment_cycle)
    {
        $this->container['payment_cycle'] = $payment_cycle;

        return $this;
    }

    /**
     * Gets payment_method
     * @return string
     */
    public function getPaymentMethod()
    {
        return $this->container['payment_method'];
    }

    /**
     * Sets payment_method
     * @param string $payment_method 
     * @return $this
     */
    public function setPaymentMethod($payment_method)
    {
        $this->container['payment_method'] = $payment_method;

        return $this;
    }

    /**
     * Gets per_seat_price
     * @return string
     */
    public function getPerSeatPrice()
    {
        return $this->container['per_seat_price'];
    }

    /**
     * Sets per_seat_price
     * @param string $per_seat_price The per seat price for the plan.
     * @return $this
     */
    public function setPerSeatPrice($per_seat_price)
    {
        $this->container['per_seat_price'] = $per_seat_price;

        return $this;
    }

    /**
     * Gets plan_classification
     * @return string
     */
    public function getPlanClassification()
    {
        return $this->container['plan_classification'];
    }

    /**
     * Sets plan_classification
     * @param string $plan_classification Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.
     * @return $this
     */
    public function setPlanClassification($plan_classification)
    {
        $this->container['plan_classification'] = $plan_classification;

        return $this;
    }

    /**
     * Gets plan_feature_sets
     * @return \DocuSign\eSign\Model\FeatureSet[]
     */
    public function getPlanFeatureSets()
    {
        return $this->container['plan_feature_sets'];
    }

    /**
     * Sets plan_feature_sets
     * @param \DocuSign\eSign\Model\FeatureSet[] $plan_feature_sets 
     * @return $this
     */
    public function setPlanFeatureSets($plan_feature_sets)
    {
        $this->container['plan_feature_sets'] = $plan_feature_sets;

        return $this;
    }

    /**
     * Gets plan_id
     * @return string
     */
    public function getPlanId()
    {
        return $this->container['plan_id'];
    }

    /**
     * Sets plan_id
     * @param string $plan_id 
     * @return $this
     */
    public function setPlanId($plan_id)
    {
        $this->container['plan_id'] = $plan_id;

        return $this;
    }

    /**
     * Gets plan_name
     * @return string
     */
    public function getPlanName()
    {
        return $this->container['plan_name'];
    }

    /**
     * Sets plan_name
     * @param string $plan_name The name of the Billing Plan.
     * @return $this
     */
    public function setPlanName($plan_name)
    {
        $this->container['plan_name'] = $plan_name;

        return $this;
    }

    /**
     * Gets seat_discounts
     * @return \DocuSign\eSign\Model\SeatDiscount[]
     */
    public function getSeatDiscounts()
    {
        return $this->container['seat_discounts'];
    }

    /**
     * Sets seat_discounts
     * @param \DocuSign\eSign\Model\SeatDiscount[] $seat_discounts 
     * @return $this
     */
    public function setSeatDiscounts($seat_discounts)
    {
        $this->container['seat_discounts'] = $seat_discounts;

        return $this;
    }

    /**
     * Gets support_incident_fee
     * @return string
     */
    public function getSupportIncidentFee()
    {
        return $this->container['support_incident_fee'];
    }

    /**
     * Sets support_incident_fee
     * @param string $support_incident_fee The support incident fee charged for each support incident.
     * @return $this
     */
    public function setSupportIncidentFee($support_incident_fee)
    {
        $this->container['support_incident_fee'] = $support_incident_fee;

        return $this;
    }

    /**
     * Gets support_plan_fee
     * @return string
     */
    public function getSupportPlanFee()
    {
        return $this->container['support_plan_fee'];
    }

    /**
     * Sets support_plan_fee
     * @param string $support_plan_fee The support plan fee charged for this plan.
     * @return $this
     */
    public function setSupportPlanFee($support_plan_fee)
    {
        $this->container['support_plan_fee'] = $support_plan_fee;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\DocuSign\eSign\ObjectSerializer::sanitizeForSerialization($this));
    }
}


